import { connect } from 'react-redux';
import { Action, bindActionCreators, Dispatch } from 'redux';
import { showModal } from 'vienna/core/actions/modal';
import { ManageDeveloperApplicationModal } from 'vienna/features/manage-developer-application/components/manage-developer-application/container';
import { CompanyPendingDevelopersTabComponent, PublicProps, ReduxDispatchProps } from './component';

function mapDispatchToProps(dispatch: Dispatch<Action>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showManageDeveloperApplicationModal: ({ ...props }) => showModal(ManageDeveloperApplicationModal, props),
    },
    dispatch,
  );
}

export const CompanyPendingDevelopersTab: React.ComponentClass<PublicProps> = connect(
  null,
  mapDispatchToProps,
)(CompanyPendingDevelopersTabComponent);
