import { connect } from 'react-redux';
import { Action, bindActionCreators, Dispatch } from 'redux';
import { showModal } from 'vienna/core/actions/modal';
import { ManageGameApplicationModal } from 'vienna/features/manage-game-application/components/manage-game-application/container';
import { CompanyPendingGamesTabComponent, PublicProps, ReduxDispatchProps } from './component';

function mapDispatchToProps(dispatch: Dispatch<Action>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showManageGameApplicationModal: ({ ...props }) => showModal(ManageGameApplicationModal, props),
    },
    dispatch,
  );
}

export const CompanyPendingGamesTab: React.ComponentClass<PublicProps> = connect(
  null,
  mapDispatchToProps,
)(CompanyPendingGamesTabComponent);
