import * as React from 'react';
import { Button, ButtonType, TableCell, TableRow } from 'twitch-core-ui';
import { ActionHistory } from 'vienna/common/clients/rbacClient';
import { Membership } from 'vienna/common/clients/rbacrpc';
import { convertDateFormat } from 'vienna/common/utils/date';
import { PublicProps as ActivityLogProps } from 'vienna/features/activity-log';

export interface PublicProps {
  membership: Membership;
  onEdit: (user: Membership) => void;
  onDelete: (user: Membership) => void;
}

export interface ReduxDispatchProps {
  showActivityLogModal: (props: ActivityLogProps) => void;
}

type Props = PublicProps & ReduxDispatchProps;

export class CompanyUsersTableRowComponent extends React.Component<Props> {
  public render() {
    return (
      <TableRow>
        <TableCell>
          <Button type={ButtonType.Text} onClick={this.manageUser}>
            {this.props.membership.firstName}
          </Button>
        </TableCell>
        <TableCell>{this.props.membership.lastName}</TableCell>
        <TableCell>{this.props.membership.devTitle}</TableCell>
        <TableCell>{this.props.membership.role}</TableCell>
        <TableCell>{this.props.membership.devEmail}</TableCell>
        <TableCell>{this.props.membership.twitchId}</TableCell>
        <TableCell>{convertDateFormat(this.props.membership.createdAt)}</TableCell>
        <TableCell>
          <Button type={ButtonType.Hollow} onClick={this.onActivityLog}>
            Activity Log
          </Button>
          &nbsp;
          <Button type={ButtonType.Hollow} onClick={this.deleteUser}>
            Delete
          </Button>
        </TableCell>
      </TableRow>
    );
  }

  private manageUser = () => {
    this.props.onEdit(this.props.membership);
  };

  private onActivityLog = async () => {
    this.props.showActivityLogModal({
      title: `${this.props.membership.firstName} ${this.props.membership.lastName}`,
      entityId: this.props.membership.twitchId,
      entityType: 'UserRole',
    });
  };

  private deleteUser = () => {
    this.props.onDelete(this.props.membership);
  };
}
