import * as React from 'react';
import { connect } from 'react-redux';
import { Action, bindActionCreators, Dispatch } from 'redux';
import { showModal } from 'vienna/core/actions/modal';
import { ActivityLogModal } from 'vienna/features/activity-log';
import { CompanyUsersTableRowComponent, PublicProps, ReduxDispatchProps } from './component';

function mapDispatchToProps(dispatch: Dispatch<Action>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showActivityLogModal: ({ ...props }) => showModal(ActivityLogModal, props),
    },
    dispatch,
  );
}

export const CompanyUsersTableRow: React.ComponentClass<PublicProps> = connect(
  null,
  mapDispatchToProps,
)(CompanyUsersTableRowComponent);
