import { connect } from 'react-redux';
import { Action, bindActionCreators, Dispatch } from 'redux';
import { showModal } from 'vienna/core/actions/modal';
import { DeleteUserModal } from 'vienna/features/delete-user/components/delete-user';
import { ManageUserModal } from 'vienna/features/manage-user';
import { CompanyUsersTabComponent, PublicProps, ReduxDispatchProps } from './component';

function mapDispatchToProps(dispatch: Dispatch<Action>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showDeleteUserModal: ({ ...props }) => showModal(DeleteUserModal, props),
      showManageUserModal: ({ ...props }) => showModal(ManageUserModal, props),
    },
    dispatch,
  );
}

export const CompanyUsersTab: React.ComponentClass<PublicProps> = connect(
  null,
  mapDispatchToProps,
)(CompanyUsersTabComponent);
