import { Button } from 'twitch-core-ui';
import { setupShallowTest } from 'vienna/tests/utils/setup';
import { CreateShadowAccountButtonComponent, Props } from './component';

const mockShowCreateShadowAccountModal = jest.fn();
const defaultPropsGenerator = (): Props => ({
  companyId: 'test_company_id',
  onCreate: jest.fn(),
  closeModal: jest.fn(),
  showCreateShadowAccountModal: mockShowCreateShadowAccountModal,
});

const setupShallow = setupShallowTest<Props, {}>(CreateShadowAccountButtonComponent, defaultPropsGenerator);

describe('test CreateShadowAccountButtonComponent', () => {
  it('renders a button', () => {
    const { wrapper } = setupShallow();

    expect(wrapper.find(Button)).toExist();
  });

  it('calls showCreateShadowAccountModal when the button is clicked', () => {
    const { wrapper } = setupShallow();

    wrapper.find(Button).simulate('click');

    expect(mockShowCreateShadowAccountModal).toBeCalled();
  });
});
