import * as React from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Action } from 'redux';
import { Dispatch } from 'redux';
import { Button, Layout } from 'twitch-core-ui';
import { closeModal, ModalShown, showModal } from 'vienna/core/actions/modal';
import {
  CreateShadowAccountModal,
  PublicProps as CreateShadowAccountProps,
} from 'vienna/pages/manage-company/components/create-shadow-account-button/modal';

interface PublicProps {
  companyId: string;
  onCreate: () => void;
}

export interface ReduxDispatchProps {
  showCreateShadowAccountModal: (props: CreateShadowAccountProps) => ModalShown;
  closeModal: () => void;
}

export type Props = PublicProps & ReduxDispatchProps;

export class CreateShadowAccountButtonComponent extends React.Component<Props> {
  public render() {
    return (
      <Layout>
        <Button onClick={this.onClick}>Create Shadow Account</Button>
      </Layout>
    );
  }

  private onClick = () => {
    this.props.showCreateShadowAccountModal({
      companyId: this.props.companyId,
      closeModal: this.props.closeModal,
      onCreate: this.props.onCreate,
    });
  };
}

function mapDispatchToProps(dispatch: Dispatch<Action>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showCreateShadowAccountModal: ({ ...props }) => showModal(CreateShadowAccountModal, props),
      closeModal,
    },
    dispatch,
  );
}

export const CreateShadowAccountButton: React.ComponentClass<PublicProps> = connect(
  null,
  mapDispatchToProps,
)(CreateShadowAccountButtonComponent);
