import * as Cookies from 'js-cookie';
import * as React from 'react';
import { Redirect, RouteComponentProps } from 'react-router';
import { Layout } from 'twitch-core-ui';
import { authenticateUserFromAuthCookie, setAuthCookie } from 'vienna/core/auth/authenticate-user';

export interface PublicProps {}

interface RouteProps {}

type Props = PublicProps & RouteComponentProps<RouteProps>;

export interface State {
  location: string;
}

class OAuthComponent extends React.Component<Props, State> {
  // Create initial state
  public state: State = {
    location: '',
  };

  public async componentDidMount() {
    if (document.location.hash.length) {
      const token = document.location.hash
        .split('#')[1]
        .split('&')
        .reduce((prev: string, next: string) => {
          if (prev.startsWith('access_token')) {
            return prev;
          } else {
            return next;
          }
        })
        .split('=')[1];

      setAuthCookie(token);
    }

    // Need to redirect to location provided by this
    const location = await authenticateUserFromAuthCookie();
    this.setState({
      location,
    });
  }

  public render() {
    return this.state.location ? <Redirect to={this.state.location} /> : <Layout>Pending...</Layout>;
  }
}

export const OAuthPage: React.ComponentClass<PublicProps> = OAuthComponent;
