import * as React from 'react';
import { RouteComponentProps } from 'react-router';
import { Display, FlexWrap, Layout, Overflow, Position } from 'twitch-core-ui';
import { ModalRoot } from 'vienna/common/components/modal/modal-root';
import { Sidebar } from 'vienna/features/sidebar';
import { RootRouter } from 'vienna/pages/root/components/root-router';
import './styles.scss';

export interface PublicProps {}

interface RouteProps {}

type Props = PublicProps & RouteComponentProps<RouteProps>;

class RootComponent extends React.Component<Props> {
  public render() {
    return (
      <Layout
        className="vienna-root"
        overflow={Overflow.Auto}
        display={Display.Flex}
        flexWrap={FlexWrap.NoWrap}
        position={Position.Absolute}
        attachTop
        attachRight
        attachBottom
        attachLeft
      >
        <Layout fullHeight>
          <Sidebar />
        </Layout>
        <Layout fullWidth padding={3} overflow={Overflow.Auto}>
          <RootRouter />
        </Layout>
        <ModalRoot />
      </Layout>
    );
  }
}

export const Root: React.ComponentClass<PublicProps> = RootComponent;
