import * as React from 'react';
import { Redirect, Route, Switch } from 'react-router-dom';
import { CompanyApplicationDirectoryPage } from 'vienna/pages/company-application-directory';
import { CompanyListPage } from 'vienna/pages/company-list';
import { DeveloperApplicationDirectoryPage } from 'vienna/pages/developer-application-directory';
import { ExtensionListPage } from 'vienna/pages/extension-list';
import { ExtensionReviewPage } from 'vienna/pages/extension-review';
import { GameApplicationDirectoryPage } from 'vienna/pages/game-application-directory';
import { LoginPage } from 'vienna/pages/login/component';
import { LogoutPage } from 'vienna/pages/logout';
import { CompanyManagePage } from 'vienna/pages/manage-company';
import { CompanyApplicationManagePage } from 'vienna/pages/manage-company-application/components/component';
import { OAuthPage } from 'vienna/pages/oauth';

export interface PublicProps {}

type Props = PublicProps;

export interface State {}

class RootRouterComponent extends React.Component<Props, State> {
  // Create initial state
  public state: State = {};

  public render() {
    // NOTE: Remember to wrap pages that require user auth with withUser() HOC
    return (
      <Switch>
        <Route render={this.renderHomePage} exact path="/" />
        <Route component={LoginPage} exact path="/login" />
        <Route component={LogoutPage} exact path="/logout" />
        <Route component={OAuthPage} exact path="/oauth/callback" />
        <Route component={CompanyListPage} exact path="/overview/companies" />
        <Route component={CompanyManagePage} exact path="/overview/companies/:companyID" />
        <Route component={CompanyApplicationDirectoryPage} exact path="/review/companies" />
        <Route component={CompanyApplicationManagePage} exact path="/review/companies/:companyApplicationID" />
        <Route component={GameApplicationDirectoryPage} exact path="/review/games" />
        <Route component={DeveloperApplicationDirectoryPage} exact path="/review/developers" />
        <Route component={ExtensionListPage} exact path="/overview/extensions" />
        <Route component={ExtensionReviewPage} exact path="/review/extensions/:id/:version/review" />{' '}
        {/* last /review needed because if the route ends in .0 it thinks it is a file and fails routing */}
        <Route render={this.renderNotFound} />
      </Switch>
    );
  }

  private renderNotFound = () => {
    return <p>Page Not Found</p>;
  };

  private renderHomePage = () => {
    return <Redirect to="/overview/companies" />;
  };
}

export const RootRouter: React.ComponentClass<PublicProps> = RootRouterComponent;
