# Terraform

Vienna is a static site, hosted in EC2 instances with Nginx and deploying using ECS. Terraform is used to provision the EC2 instances.


Terraform needs access to the AWS accounts `twitch-rbac-dev` (staging) and `twitch-rbac-prod` (production). Make sure you have access through Isengard. Go to the `IAM` service. Go to your IAM user (create it if this is the first time), go to "Security Credentials" and make a new Access Key. Then copy-paste the key ID and Secret into your `.aws/credentials` file, for example:

```
[twitch-rbac-dev]
aws_access_key_id = ASIAQ3PXXXXXXXXXLJ5F
aws_secret_access_key = sUMK+7tZRTL/JTtDXXXXXXXX2L7bcSFKdkFq34Fc
```

## Scripts

Go to the `/terraform` folder, and use the wrapper command for common operations.

*Plan* for the `service` folder in staging:

```sh
AWS_PROFILE=twitch-rbac-dev AWS_DEFAULT_REGION=us-west-2 TF_FOLDER=service ./docker-tf.sh ./plan.sh
```

*Apply* the generated plan diff in `staging`:

```sh
AWS_PROFILE=twitch-rbac-dev AWS_DEFAULT_REGION=us-west-2 TF_FOLDER=service ./docker-tf.sh ./apply.sh
```

Fix Formatting:

```sh
./docker-tf.sh terraform fmt
```

Heavily inspired by https://git-aws.internal.justin.tv/edge/websub/tree/master/terraform#websub-infrastructure

## DNS and SSL Certificates

DNS is not managed through terraform (used to be, but now is not tracked for simplicity). The last DNS update is tracked in this JIRA: https://jira.twitch.com/browse/INS-1524

Setup:

 * twitch-rbac-prod account:
   * Route 53: hosted zone devsite-vienna.xarth.tv. Is delegated and has an ALIAS record for the production Load Balancer (devsite-vienna.xarth.tv), and another for the staging Load Balancer (staging.devsite-vienna.xarth.tv)
   * Certificate Manager: has the SSL certificate, validated with DNS.
   * Load Balancer: uses the certificate arn on port 443 (this is done in terraform)
 * twitch-rbac-dev account:
   * Certificate Manager: has the SSL certificate, validated with DNS using the CNAME defined in the production hosted zone.
   * Load Balancer: uses the new certificate on port 443 (this is done in terraform)
