data "aws_iam_policy_document" "ecs_task_assume" {
  statement {
    actions = ["sts:AssumeRole"]
    effect  = "Allow"

    principals {
      identifiers = ["ecs-tasks.amazonaws.com"]
      type        = "Service"
    }
  }
}

resource "aws_iam_role" "ecs_task" {
  name               = "${var.team}-${var.environment}-ecs-task"
  assume_role_policy = "${data.aws_iam_policy_document.ecs_task_assume.json}"
}

data "aws_iam_policy_document" "sandstorm" {
  statement {
    actions   = ["sts:AssumeRole"]
    effect    = "Allow"
    resources = ["${var.sandstorm_role_arn}"]
  }
}

resource "aws_iam_role_policy" "sandstorm" {
  name   = "sandstorm"
  policy = "${data.aws_iam_policy_document.sandstorm.json}"
  role   = "${aws_iam_role.ecs_task.name}"
}
