#!/bin/ash -e

function die() {
  echo "$@" >&2
  exit 1
}

# If we're not already there, move to the same directory as the script.
[[ -n "$(dirname $0)" ]] && cd $(dirname $0)


# AWS_PROFILE defines the environment folder
if [ "$AWS_PROFILE" = "twitch-rbac-prod" ]
then
  environment="production"
elif [ "$AWS_PROFILE" = "twitch-rbac-dev" ]
then
  environment="staging"
else
  die "AWS_PROFILE environment variable must be twitch-rbac-dev (staging) or twitch-rbac-prod (production)"
fi

# Folder with the module to run (account, service)
[[ -z "$TF_FOLDER" ]] && die "TF_FOLDER environment variable required."
[[ ! -d "$TF_FOLDER" ]] && die "TF_FOLDER environment variable must identify a terraform module to run."

tfvars="${PWD}/tfvars/$environment-$(basename $TF_FOLDER).tfvars"
[[ ! -f "$tfvars" ]] && die "Could not find file $tfvars"

cd "$TF_FOLDER"

terraform apply "${environment}".tf_plan
