locals {
  dnsmasq_cache_size = 8192
  dnsmasq_memory     = 500
  dnsmasq_version    = "2.78"
}

data "aws_region" "current" {}

data "template_file" "dns_taskdef" {
  template = "${file("${path.module}/dnsmasq.json.tmpl")}"

  vars {
    cache_size      = "${local.dnsmasq_cache_size}"
    dnsmasq_version = "${local.dnsmasq_version}"
    log_group       = "${aws_cloudwatch_log_group.dns.name}"
    memory          = "${local.dnsmasq_memory}"
    region          = "${data.aws_region.current.name}"
  }
}

resource "aws_ecs_task_definition" "dns" {
  family                = "dnsmasq"
  container_definitions = "${data.template_file.dns_taskdef.rendered}"
  network_mode          = "host"

  depends_on = ["aws_cloudwatch_log_group.dns"]
}

resource "aws_cloudwatch_log_group" "dns" {
  name = "hubsights-dns"

  tags = {
    Owner       = "${var.owner}"
    Service     = "dns"
    Environment = "${var.environment}"
  }
}

module "dns-daemon" {
  source      = "git::git+ssh://git@git-aws.internal.justin.tv/twitch/terraform//perhostdaemon?ref=v0.8.16"
  service     = "dns"
  cluster     = "${aws_ecs_cluster.cluster.name}"
  task_family = "${aws_ecs_task_definition.dns.arn}"
}
