variable "container_instance_profile_id" {
  description = "The permissions ID these hosts get. Should probably use the one created by core."
}

variable "environment" {
  description = "Which env run of the service (staging/production/etc)"
}

variable "instance_type" {
  default     = "c5.xlarge"
  description = "AWS instance type of these hosts (c4.2xlarge, etc)"
}

variable "ldap_group" {
  default     = "infra"
  description = "LDAP group to add to sudoers"
}

variable "max_size" {
  description = "Most number of hosts to have in this ASG"
}

variable "min_size" {
  description = "Least number of hosts to have in this ASG"
}

variable "name" {
  description = "Name of the cluster"
}

variable "owner" {
  description = "Owner's email that wants twitch to pay for this."
}

variable "security_groups" {
  description = "Twitch subnet security groups to add EC2 instances into."
  type        = "string"
}

variable "ssm_agent_loggroup" {
  description = "CloudWatch log group to send SSM agent logs to."
}

variable "team" {
  description = "The twitch team (feeds/events/etc) that wants this resource"
  default     = "hubsights"
}

variable "vpc_subnet_ids" {
  description = "Subnets that ASG adds hosts to."
  type        = "list"
}
