terraform {
  backend "s3" {
    key    = "tfstate/devrel/vienna/terraform/service/terraform.tfstate"
    region = "us-west-2"
  }
}

data "aws_iam_account_alias" "current" {}
data "aws_region" "current" {}

module "vpc" {
  source = "../vpc"
}

data "terraform_remote_state" "account" {
  backend = "s3"

  config {
    bucket = "${data.aws_iam_account_alias.current.account_alias}"
    key    = "tfstate/devrel/vienna/terraform/account/terraform.tfstate"
    region = "us-west-2"
  }
}
