resource "aws_sns_topic" "pd_high_urgency" {
  name         = "hubsights-alarms-high-urgency-${var.environment}"
  display_name = "hubsights-alarms-high-urgency-${var.environment}"
}

resource "aws_sns_topic_subscription" "high" {
  protocol               = "https"
  endpoint_auto_confirms = true
  endpoint               = "https://events.pagerduty.com/integration/${var.pagerduty_key["high"]}/enqueue"
  topic_arn              = "${aws_sns_topic.pd_high_urgency.arn}"
}

resource "aws_sns_topic" "pd_low_urgency" {
  name         = "hubsights-alarms-low-urgency-${var.environment}"
  display_name = "hubsights-alarms-low-urgency-${var.environment}"
}

resource "aws_sns_topic_subscription" "low" {
  protocol               = "https"
  endpoint_auto_confirms = true
  endpoint               = "https://events.pagerduty.com/integration/${var.pagerduty_key["low"]}/enqueue"
  topic_arn              = "${aws_sns_topic.pd_low_urgency.arn}"
}
