#!/usr/bin/python

import requests
import sys
import time
import urllib


JAX_BASE_URL = 'http://jax-internal-production.us-west2.justin.tv/'
JAX_STREAM_STR = 'stream/list'


def make_get_request(base_url, params):
    if False:
        print('params: %s' % params)
    resp = requests.get(base_url, params = params)
    try:
        output = resp.json()
        return output
    except Exception as e:
        print('Error in get request. %s ' % e)
        print('response: %s ' % resp)
    return None


def parse_jax_resp(jax_resp):
    live_channel_ids = []
    live_channel_names = []
    
    channels_info = jax_resp.get('hits', None)
    if not channels_info:
        if False:
            print('Channels info - hits - is empty')
        return live_channel_ids, live_channel_names

    for channel_props in channels_info:
        props = channel_props.get('properties', None)
        if not props:
            continue
        rails = props.get('rails', None)
        if not rails:
            continue
        channel_id = rails.get('channel_id')
        if not channel_id:
            continue
        channel_name = rails.get('channel')
        if not channel_name:
            continue
        live_channel_ids.append(channel_id)
        live_channel_names.append(channel_name)
    return live_channel_ids, live_channel_names


# Args: 
# channel_ids: A list of channel ids (integers)
# Output:  A dictionary with keys as channel_ids, values are bool. True if channel is live
def get_live_channels(channel_ids):

    channel_live_info_dict = {}
    for channel_id in channel_ids:
        channel_live_info_dict[channel_id] = False

    channel_ids_str = ','.join([str(i) for i in channel_ids])
    params = {'channel_ids' : channel_ids_str,
              'stream_type' : 'live'}
    jax_url = '%s%s' % (JAX_BASE_URL, JAX_STREAM_STR)
    jax_resp = make_get_request(jax_url, params)
    if not jax_resp:
        print('Jax output is empty')
        return None
    live_channel_ids, live_channel_names = parse_jax_resp(jax_resp)

    for live_channel in live_channel_ids:
        channel_live_info_dict[live_channel] = True
    return channel_live_info_dict


# Args: 
# channel_ids: A list of channel names
# Output:  A dictionary with keys as channel names, values are bool. True if channel is live
def get_live_from_channel_names(channel_names):
    channel_live_info_dict = {}
    for channel_name in channel_names:
        channel_live_info_dict[channel_name] = False

    channel_ids_str = ','.join(channel_names)
    params = {'channels' : channel_ids_str}
    jax_url = '%s%s' % (JAX_BASE_URL, JAX_STREAM_STR)
    jax_resp = make_get_request(jax_url, params)
    if not jax_resp:
        print('Jax output is empty')
        return None
    live_channel_ids, live_channel_names = parse_jax_resp(jax_resp)

    for live_channel_name in live_channel_names:
        channel_live_info_dict[live_channel_name] = True
    return channel_live_info_dict


def main(argv):
    # Sample Channel ids to test Jax Query with Channel Ids
    channel_ids = [71068671, 87204022, 132954738]
    channel_ids_info = get_live_channels(channel_ids)
    print(' Live Channel Info: %s' % channel_ids_info)

    # Sample Channel ids to test Jax Query with Channel Names
    channel_names = ['aws','lirik','failarmy']
    channel_names_info = get_live_from_channel_names(channel_names)
    print(' Live Channel Info: %s' % channel_names_info)

if __name__ == '__main__':
    main(sys.argv[1:])


