package main

import (
	"errors"
	"log"
	"regexp"
)

/*Given an email, find out if they made payments*/
func AdminGetPayments(email string) (int, error) {
	VALID_EMAIL_REGEX := "^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$"
	r, err := regexp.Compile(VALID_EMAIL_REGEX)
	if err != nil {
		errStr := "Error: Invalid VALID_EMAIL_REGEX regex"
		log.Println(errStr, err)
		return 0, errors.New(errStr)
	}
	if r.MatchString(email) != true {
		errStr := "Error: Invalid username"
		log.Println(errStr, err)
		return 0, errors.New(errStr)
	}
	stmt := "SELECT count(id) as count FROM purchase_profiles WHERE purchaser_email = $1"

	rows, err := siteDB.Query(stmt, email)
	if err != nil {
		errStr := "Error with getting rows"
		log.Println(errStr, err)
		return 0, errors.New(errStr)
	}
	defer rows.Close()
	for rows.Next() {
		var count int
		err := rows.Scan(&count)
		if err != nil {
			errStr := "Error scanning row"
			log.Println(errStr, err)
			return 0, errors.New(errStr)
		}
		log.Println(count)
		return count, nil

	}
	return 0, errors.New("count not found")
}
