package main

import (
	"encoding/json"
	"errors"
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
	"strconv"
)

/* Get the full message from a given case*/
func getDeskMessage(caseID string) (string, error) {
	client := &http.Client{Transport: tr}
	fetchURL := "https://help.twitch.tv/api/v2/cases/" + caseID + "/message"
	req, err := http.NewRequest("GET", fetchURL, nil)
	if err != nil {
		errStr := "Failed to create NewRequest"
		log.Println(errStr, err)
		return "", errors.New(errStr)
	}
	header, err := GetOAuthHeader(req)
	if err != nil {
		return "", err
	}

	req.Header.Add("Authorization", header)

	resp, err := client.Do(req)
	if err != nil {
		return "", err
	}
	defer resp.Body.Close()

	limit, err := strconv.Atoi(resp.Header.Get("X-Rate-Limit-Remaining"))
	if err != nil {
		return "", err
	}
	if limit < 1 {
		return "", fmt.Errorf("Over rate limit. Remaining %d", limit)
	}

	if ignoreStatus(resp.StatusCode) == true {
		return "", fmt.Errorf("Bad status for getting desk message: %d", resp.StatusCode)
	}

	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return "", err
	}

	var data DeskMessage
	err = json.Unmarshal(body, &data)
	if err != nil {
		return "", err
	}
	return data.Body, nil
}
