package main

/*Patch a specific desk case with an array of labels, and a new priority.*/ import (
	"bytes"
	"code.justin.tv/xangold/httpclient"
	"encoding/json"
	"fmt"
	"net/http"
	"strconv"
	"strings"
	"time"
)

func updateLabels(caseID string, labels []string, priority string) error {
	postURL := "https://help.twitch.tv/api/v2/cases/" + caseID
	//I feel there is a lot of cleanup that can happen in this function. When I remove the ToLower() it fails
	payload, err := json.Marshal(&LabelPayload{Label_action: "append", Labels: labels, Priority: priority})
	if err != nil {
		return err
	}
	client := httpclient.GetHTTPClient(30*time.Second, 30*time.Second)
	req, err := http.NewRequest("PATCH", postURL, bytes.NewBufferString(strings.ToLower(string(payload[:]))))
	if err != nil {
		return err
	}
	header, err := GetOAuthHeader(req)
	if err != nil {
		return err
	}

	req.Header.Add("Authorization", header)

	if err != nil {
		return err

	}
	resp, err := client.Do(req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()
	limit, err := strconv.Atoi(resp.Header.Get("X-Rate-Limit-Remaining"))
	if err != nil {
		return err
	}
	if limit < 1 {
		_, err := strconv.Atoi(resp.Header.Get("X-Rate-Limit-Reset"))
		if err != nil {
			return err
		}
		return fmt.Errorf("Over limit for updating labels. Limit: %d", limit)
	}
	if ignoreStatus(resp.StatusCode) == true {
		return fmt.Errorf("Bad status code for updating lables: %d", resp.StatusCode)
	}
	return nil
}
