package httpclient

import (
	"net"
	"net/http"
	"time"
)

type HTTPConfig struct {
	ConnectTimeout   time.Duration
	ReadWriteTimeout time.Duration
}

//seconds of timeout
func GetHTTPClient(connect time.Duration, read time.Duration) *http.Client {
	config := &HTTPConfig{
		ConnectTimeout:   connect,
		ReadWriteTimeout: read,
	}
	return &http.Client{
		Transport: &http.Transport{
			Dial: timeoutDialer(config),
		},
	}
}

func timeoutDialer(config *HTTPConfig) func(net, addr string) (c net.Conn, err error) {
	return func(netw, addr string) (net.Conn, error) {
		conn, err := net.DialTimeout(netw, addr, config.ConnectTimeout)
		if err != nil {
			return nil, err
		}
		conn.SetDeadline(time.Now().Add(config.ReadWriteTimeout))
		return conn, nil
	}
}
