package multiconfig

import (
	"fmt"
	"log"
	"time"
)

// DurationVar registers a new duration config option. See the flag package for
// more details.
func (c *Config) DurationVar(dest *time.Duration, name string, defaultValue time.Duration, usage string) {
	if name == "config" {
		log.Fatalf("%q is a reserved flag", name)
	}

	var fv flagVar
	c.flagSet.Var(&fv, name, usage)

	c.funcs = append(c.funcs, func() error {
		value, found := c.lookupOption(name, &fv)
		if !found {
			*dest = defaultValue
			return nil
		}

		res, err := time.ParseDuration(value)
		if err != nil {
			return fmt.Errorf("Error loading %s: %v", name, err)
		}
		*dest = res

		return nil
	})
}
