package multiconfig

import (
	"fmt"
	"log"
	"strconv"
)

// IntVar registers a new int config option. See the flag package for
// more details.
func (c *Config) IntVar(dest *int, name string, defaultValue int, usage string) {
	if name == "config" {
		log.Fatalf("%q is a reserved flag", name)
	}

	var fv flagVar
	c.flagSet.Var(&fv, name, usage)

	c.funcs = append(c.funcs, func() error {
		value, found := c.lookupOption(name, &fv)
		if !found {
			*dest = defaultValue
			return nil
		}

		res, err := strconv.Atoi(value)
		if err != nil {
			return fmt.Errorf("Error loading %s: %v", name, err)
		}
		*dest = res

		return nil
	})
}
