package trace

import (
	"expvar"
	"sync/atomic"

	"code.justin.tv/common/golibs/pkgpath"
)

func init() {
	pkg, ok := pkgpath.Caller(0)
	if !ok {
		return
	}

	expvar.Publish(pkg, expvar.Func(func() interface{} { return exp.dup() }))
}

type expdata struct {
	NoProcInfo    int64
	NoTransaction int64
	MarshalError  int64
	ShortWrite    int64
	WriteError    int64
	FlushError    int64

	EntropyUnderflow int64
}

func (ed *expdata) dup() *expdata {
	var out expdata

	out.NoProcInfo = atomic.LoadInt64(&ed.NoProcInfo)
	out.NoTransaction = atomic.LoadInt64(&ed.NoTransaction)
	out.MarshalError = atomic.LoadInt64(&ed.MarshalError)
	out.ShortWrite = atomic.LoadInt64(&ed.ShortWrite)
	out.WriteError = atomic.LoadInt64(&ed.WriteError)
	out.FlushError = atomic.LoadInt64(&ed.FlushError)

	out.EntropyUnderflow = atomic.LoadInt64(&ed.EntropyUnderflow)

	return &out
}

var exp expdata
