package main

import (
	"fmt"
	"log"
	"time"

	"code.justin.tv/common/gometrics"
	"github.com/cactus/go-statsd-client/statsd"
)

func main() {
	stats, err := statsd.NewClient("graphite.internal.justin.tv:8125", "gometrics_example")
	if err != nil {
		log.Fatal(err)
	}

	gometrics.Monitor(stats, time.Second*5)

	go func() {
		for {
			_ = fmt.Sprintf("foo %v", "bar")
		}
	}()

	for {
		time.Sleep(1 * time.Second)
	}
}
