// Code generated by protoc-gen-go.
// source: code.justin.tv/release/trace/events/event.proto
// DO NOT EDIT!

/*
Package events is a generated protocol buffer package.

It is generated from these files:
	code.justin.tv/release/trace/events/event.proto

It has these top-level messages:
	Event
	Extra
	ExtraHTTP
	ExtraSQL
	ExtraMemcached
	ExtraGRPC
	UnusedExtra
	EventSet
*/
package events

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import code_justin_tv_release_trace_common "code.justin.tv/release/trace/common"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// An Event represents a single Trace-worthy event.  This includes RPC
// lifecycle events (client started to send a request, server finishes sending
// a response), and application-specific custom events.
type Event struct {
	// Lifecycle event this message is attached to
	Kind code_justin_tv_release_trace_common.Kind `protobuf:"varint,1,opt,name=kind,enum=code.justin.tv.release.trace.common.event.Kind" json:"kind,omitempty"`
	// Unix epoch time in nanoseconds, as measured by the process
	Time int64 `protobuf:"fixed64,2,opt,name=time" json:"time,omitempty"`
	// FQDN of the process's host
	Hostname string `protobuf:"bytes,3,opt,name=hostname" json:"hostname,omitempty"`
	// Service name of the process
	Svcname string `protobuf:"bytes,4,opt,name=svcname" json:"svcname,omitempty"`
	// PID of the process
	Pid int32 `protobuf:"varint,5,opt,name=pid" json:"pid,omitempty"`
	// 128-bit identifier for the entire transaction.  This field is sent as
	// two 64-bit integers, least significant word first.
	TransactionId []uint64 `protobuf:"fixed64,6,rep,packed,name=transaction_id" json:"transaction_id,omitempty"`
	// Identifier for a single RPC span (one request leading to one response).
	// Each level of the distributed call stack adds a new element to the path
	// field.  The value at each level is the (zero-indexed) number of
	// outbound RPC requests made at that level.
	Path []uint32 `protobuf:"varint,7,rep,packed,name=path" json:"path,omitempty"`
	// Additional protocol-specific information
	Extra *Extra `protobuf:"bytes,8,opt,name=extra" json:"extra,omitempty"`
	// Amazon Resource Name for the process's EC2 instance.  This may be sent
	// instead of the hostname field.
	Ec2Arn string `protobuf:"bytes,20,opt,name=ec2_arn" json:"ec2_arn,omitempty"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}

func (m *Event) GetExtra() *Extra {
	if m != nil {
		return m.Extra
	}
	return nil
}

// An Extra describes protocol-specific information to be associated with an
// Event.
type Extra struct {
	// The address of the peer.  This could be an ipv4:port pair, [ipv6]:port
	// pair, or hostname:port pair for TCP/UDP-based protocols, a bare IP
	// address or hostname for IP- based protocols, or a path to a unix domain
	// socket.
	//
	// This field is NOT an attempt to identify the client, e.g. via the HTTP
	// X-Forwarded-For header.
	Peer string `protobuf:"bytes,1,opt,name=peer" json:"peer,omitempty"`
	// Additional HTTP-specific information for the Event.
	Http *ExtraHTTP `protobuf:"bytes,2,opt,name=http" json:"http,omitempty"`
	// Additional SQL-specific information for the Event.
	Sql *ExtraSQL `protobuf:"bytes,3,opt,name=sql" json:"sql,omitempty"`
	// Additional Memcached-specific information for the Event.
	Memcached *ExtraMemcached `protobuf:"bytes,4,opt,name=memcached" json:"memcached,omitempty"`
	// Additional gRPC-specific information for the Event.
	Grpc *ExtraGRPC `protobuf:"bytes,5,opt,name=grpc" json:"grpc,omitempty"`
}

func (m *Extra) Reset()         { *m = Extra{} }
func (m *Extra) String() string { return proto.CompactTextString(m) }
func (*Extra) ProtoMessage()    {}

func (m *Extra) GetHttp() *ExtraHTTP {
	if m != nil {
		return m.Http
	}
	return nil
}

func (m *Extra) GetSql() *ExtraSQL {
	if m != nil {
		return m.Sql
	}
	return nil
}

func (m *Extra) GetMemcached() *ExtraMemcached {
	if m != nil {
		return m.Memcached
	}
	return nil
}

func (m *Extra) GetGrpc() *ExtraGRPC {
	if m != nil {
		return m.Grpc
	}
	return nil
}

// An ExtraHTTP describes HTTP-specific information to be associated with an
// Event.
type ExtraHTTP struct {
	// Status code of HTTP response.  Common values will include 200 or 404.
	// Values less than zero indicate an error observed by the client which
	// caused it to give up on the request before getting a status code from
	// the server.
	StatusCode int32 `protobuf:"zigzag32,1,opt,name=status_code" json:"status_code,omitempty"`
	// Method of HTTP request.
	Method code_justin_tv_release_trace_common.Method `protobuf:"varint,2,opt,name=method,enum=code.justin.tv.release.trace.common.http.Method" json:"method,omitempty"`
	// Path of the HTTP request.  This is only the path - the scheme,
	// hostname, query, and fragment are not included.
	UriPath string `protobuf:"bytes,16,opt,name=uri_path" json:"uri_path,omitempty"`
}

func (m *ExtraHTTP) Reset()         { *m = ExtraHTTP{} }
func (m *ExtraHTTP) String() string { return proto.CompactTextString(m) }
func (*ExtraHTTP) ProtoMessage()    {}

// An ExtraSQL describes SQL-specific information to be associated with an
// Event.
type ExtraSQL struct {
	// Name of the target database.
	DatabaseName string `protobuf:"bytes,1,opt,name=database_name" json:"database_name,omitempty"`
	// Username used to connect to the target database.
	DatabaseUser string `protobuf:"bytes,2,opt,name=database_user" json:"database_user,omitempty"`
	// Query string with all user data removed: e.g. strings replaced by '',
	// integers replaced by 0, etc.  This value may be truncated (particularly
	// if it's larger than 1kB).
	StrippedQuery string `protobuf:"bytes,16,opt,name=stripped_query" json:"stripped_query,omitempty"`
}

func (m *ExtraSQL) Reset()         { *m = ExtraSQL{} }
func (m *ExtraSQL) String() string { return proto.CompactTextString(m) }
func (*ExtraSQL) ProtoMessage()    {}

// An ExtraMemcached describes memcached-specific information to be
// associated with an event. Most of this was written with the
// assistance of the memcached protocol spec at
// https://github.com/memcached/memcached/blob/c10feb9ebe2179f6fbe4ac2e3cd12bfefdd42631/doc/protocol.txt.
type ExtraMemcached struct {
	// The command sent to memcached by a client
	Command code_justin_tv_release_trace_common.Command `protobuf:"varint,1,opt,name=command,enum=code.justin.tv.release.trace.common.memcached.Command" json:"command,omitempty"`
	// The number of keys in this memcached event. This is useful
	// for understanding bulk transactions: the request side might
	// ask for 150 keys, but the response side might have only
	// 100, indicating that the cache was hit for 100 out of the
	// 150 requested keys.
	NKeys uint32 `protobuf:"varint,2,opt,name=n_keys" json:"n_keys,omitempty"`
	// Some commands involve the client setting a 32-bit integer
	// expiration time. According to the memcached protocol spec,
	// this may be either a Unix time, or a number of seconds
	// starting from current time. The memcached server decides
	// which it is by the size of the expiration time: if the
	// value is less than or equal to 60*60*24*30 (30 days), then
	// it's taken as a relative expiration; if it's over this
	// amount then it is interpreted as Unix time. If its set to
	// zero, then the item never expires.
	Expiration uint32 `protobuf:"fixed32,3,opt,name=expiration" json:"expiration,omitempty"`
}

func (m *ExtraMemcached) Reset()         { *m = ExtraMemcached{} }
func (m *ExtraMemcached) String() string { return proto.CompactTextString(m) }
func (*ExtraMemcached) ProtoMessage()    {}

// An ExtraGRPC describes gRPC-specific information to be associated with an
// event.
type ExtraGRPC struct {
	// Fully-qualified method name, including proto package name, service
	// name, and method name.
	Method string `protobuf:"bytes,1,opt,name=method" json:"method,omitempty"`
}

func (m *ExtraGRPC) Reset()         { *m = ExtraGRPC{} }
func (m *ExtraGRPC) String() string { return proto.CompactTextString(m) }
func (*ExtraGRPC) ProtoMessage()    {}

// An UnusedExtra describes protocol-specific information to be associated
// with an Event.  This message is not yet ready for use, meaning that the
// field names, identities, and numbers are subject to change!
type UnusedExtra struct {
	// written by an engineer - "string" means utf-8 encoded, which should be
	// fine?
	Text          string `protobuf:"bytes,20,opt,name=text" json:"text,omitempty"`
	TextTruncated bool   `protobuf:"varint,1020,opt,name=text_truncated" json:"text_truncated,omitempty"`
	// if there's a payload, how big is it?
	PayloadSize int64 `protobuf:"varint,21,opt,name=payload_size" json:"payload_size,omitempty"`
	// request uri
	HttpUri          string `protobuf:"bytes,41,opt,name=http_uri" json:"http_uri,omitempty"`
	HttpUriTruncated bool   `protobuf:"varint,1041,opt,name=http_uri_truncated" json:"http_uri_truncated,omitempty"`
	// headers, partial list
	HttpHeader []*UnusedExtra_KV `protobuf:"bytes,43,rep,name=http_header" json:"http_header,omitempty"`
	// if there are headers that we expect to be very long, we may want to
	// pull them out into their own fields so we can note when we truncate
	// them
	HttpReferer          string `protobuf:"bytes,44,opt,name=http_referer" json:"http_referer,omitempty"`
	HttpRefererTruncated bool   `protobuf:"varint,1044,opt,name=http_referer_truncated" json:"http_referer_truncated,omitempty"`
}

func (m *UnusedExtra) Reset()         { *m = UnusedExtra{} }
func (m *UnusedExtra) String() string { return proto.CompactTextString(m) }
func (*UnusedExtra) ProtoMessage()    {}

func (m *UnusedExtra) GetHttpHeader() []*UnusedExtra_KV {
	if m != nil {
		return m.HttpHeader
	}
	return nil
}

// if we use proto3 we can just use maps
type UnusedExtra_KV struct {
	// option map_entry = true;
	Key   string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *UnusedExtra_KV) Reset()         { *m = UnusedExtra_KV{} }
func (m *UnusedExtra_KV) String() string { return proto.CompactTextString(m) }
func (*UnusedExtra_KV) ProtoMessage()    {}

// An EventSet is a list of Events.  It may be used when sending multiple
// events in a datagram, or when saving them to disk.  There is no codified or
// implied relation between Events grouped into an EventSet.
type EventSet struct {
	// List of Events
	Event []*Event `protobuf:"bytes,1,rep,name=event" json:"event,omitempty"`
}

func (m *EventSet) Reset()         { *m = EventSet{} }
func (m *EventSet) String() string { return proto.CompactTextString(m) }
func (*EventSet) ProtoMessage()    {}

func (m *EventSet) GetEvent() []*Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func init() {
	proto.RegisterType((*Event)(nil), "code.justin.tv.release.trace.events.Event")
	proto.RegisterType((*Extra)(nil), "code.justin.tv.release.trace.events.Extra")
	proto.RegisterType((*ExtraHTTP)(nil), "code.justin.tv.release.trace.events.ExtraHTTP")
	proto.RegisterType((*ExtraSQL)(nil), "code.justin.tv.release.trace.events.ExtraSQL")
	proto.RegisterType((*ExtraMemcached)(nil), "code.justin.tv.release.trace.events.ExtraMemcached")
	proto.RegisterType((*ExtraGRPC)(nil), "code.justin.tv.release.trace.events.ExtraGRPC")
	proto.RegisterType((*UnusedExtra)(nil), "code.justin.tv.release.trace.events.UnusedExtra")
	proto.RegisterType((*UnusedExtra_KV)(nil), "code.justin.tv.release.trace.events.UnusedExtra.KV")
	proto.RegisterType((*EventSet)(nil), "code.justin.tv.release.trace.events.EventSet")
}
