﻿using System;
using System.Linq;
using Curse.AGS.Users;
using Curse.Cobalt.Identification;
using Curse.Cobalt.Users;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Moq;

namespace Curse.AGS.UnitTests
{
    [TestClass]
    public class BulkUserCreatorTests
    {
        [TestMethod]
        public void PassingEmptyListOfUsersAddsToFailures()
        {
            var userCreator = new Mock<IUserCreator>();
            userCreator.Setup(x => x.CreateUser("daniel", string.Empty, 1, 2));

            var externalUserIdentifier = new Mock<IExternalUserIdentifier>();

            var sut = new BulkUserCreator(userCreator.Object, externalUserIdentifier.Object);
            var result = sut.BulkCreateUsers(new UserToCreate[0]);
            Assert.AreEqual(1, result.FailedImports.Count);
            Assert.AreEqual(0, result.SuccessfulImports.Count);
        }

        [TestMethod]
        public void ImportSkippedWhenUserAlreadyImported()
        {
            var userCreator = new Mock<IUserCreator>();
            userCreator.Setup(x => x.CreateUser("daniel", string.Empty, 1, 2));

            var externalUserIdentifier = new Mock<IExternalUserIdentifier>();
            externalUserIdentifier.Setup(x => x.IdentifyExternalUser(1, 2))
                .Returns(new IdentificationResult { UserID = 1 });

            var sut = new BulkUserCreator(userCreator.Object, externalUserIdentifier.Object);
            var result = sut.BulkCreateUsers(new[] { new UserToCreate("daniel", 1) });
            Assert.AreEqual(1, result.FailedImports.Count);
            Assert.AreEqual("daniel already exists. Skipping import.", result.FailedImports.First());
            Assert.AreEqual(0, result.SuccessfulImports.Count);
        }

        [TestMethod]
        public void SuccessfullyCreatingAUserAddsToSuccessList()
        {
            // This test case cannot be tested because of a Cobalt model
        }

        [TestMethod]
        public void UnexpectedFailuresDuringCreationAddToFailuresList()
        {
            var userCreator = new Mock<IUserCreator>();
            userCreator.Setup(x => x.CreateUser("daniel", string.Empty, 1, 2))
                .Throws(new NullReferenceException());

            var externalUserIdentifier = new Mock<IExternalUserIdentifier>();
            externalUserIdentifier.Setup(x => x.IdentifyExternalUser(1, 2))
                .Returns(new IdentificationResult());

            var sut = new BulkUserCreator(userCreator.Object, externalUserIdentifier.Object);
            var result = sut.BulkCreateUsers(new[] { new UserToCreate("daniel", 1) });
            Assert.AreEqual(1, result.FailedImports.Count);
            Assert.AreEqual("Failed to import 'daniel'. Object reference not set to an instance of an object.", result.FailedImports.First());
            Assert.AreEqual(0, result.SuccessfulImports.Count);
        }
    }
}
