﻿using Curse.AGS.FileReaders;
using Curse.AGS.Forums;
using Curse.AGS.LwaDirectedIds;
using Curse.AGS.Roles;
using Curse.AGS.Users;
using Curse.AGS.Users.Importers;
using Curse.Cobalt;
using Curse.Cobalt.AmazonAuth;
using Curse.Cobalt.IOC;
using Curse.Cobalt.SecretManagement;
using Curse.Cobalt.SecretManagement.AWS;

namespace Curse.AGS.Web
{
    public class IOCConfig
    {
        public static void Register()
        {
            var iocContainer = new CobaltIOCContainer();
            iocContainer.Bind<IUserImporter, AGSAlphaUserImporter>();
            iocContainer.Bind<IBulkUserCreator, BulkUserCreator>();
            iocContainer.Bind<IBulkRoleAssigner, BulkRoleAssigner>();
            iocContainer.Bind<IFileReader, CSVFileReader>();
            iocContainer.Bind<IForumEmailMapRepository, ForumEmailMapRepository>();

            if(CobaltConfiguration.ActiveConfiguration == CobaltConfiguration.ConfigurationMode.Production)
            {
                iocContainer.BindSingleton<ISecretKeyStorage>(new AWSSecretsSecretKeyStorage(new AWSSecretsManagerConfig
                {
                    Environment = "production",
                    RegionEndpoint = "us-east-1",
                    SecretsConfigRepository = iocContainer.GetInstance<ISecretsConfigRepository>()
                }));
            }

            iocContainer.Bind<IAmazonApi, AmazonApi>();
            iocContainer.Bind<IAmazonApiConfigHelper, AmazonApiConfigHelper>();
            iocContainer.Bind<IAmazonApiUrlHelper, AmazonApiUrlHelper>();

            iocContainer.Bind<ILwaDirectedIdsExporter, LwaDirectedIdsExporter>();
            iocContainer.Bind<ILwaPermissionAssigner, LwaPermissionAssigner>();
        }
    }
}