﻿AGS.Routes.AttachmentAdd = function(attachmentID, routeValues) {
    return AGS.Routes.buildRoute("/attachment/{0}/add".format(attachmentID), routeValues);
};
AGS.Routes.AttachmentDelete = function(attachmentID, routeValues) {
    return AGS.Routes.buildRoute("/attachment/{0}/delete".format(attachmentID), routeValues);
};
AGS.Routes.AttachmentDeleteAttachment = function(modelTypeID, id, routeValues) {
    return AGS.Routes.buildRoute("/attachment/delete-attachment/{0}-{1}".format(modelTypeID, id), routeValues);
};
AGS.Routes.AttachmentRename = function(attachmentID, routeValues) {
    return AGS.Routes.buildRoute("/attachment/{0}/rename".format(attachmentID), routeValues);
};
AGS.Routes.AudioRename = function(audioID, routeValues) {
    return AGS.Routes.buildRoute("/audio/{0}/rename".format(audioID), routeValues);
};
AGS.Routes.AuthenticationAjaxCheckAvailableEmail = function(routeValues) {
    return AGS.Routes.buildRoute("/user/email/available", routeValues);
};
AGS.Routes.AuthenticationAjaxUserNameIsAvilableCheck = function(routeValues) {
    return AGS.Routes.buildRoute("/user/available", routeValues);
};
AGS.Routes.AvatarActivateAvatar = function(routeValues) {
    return AGS.Routes.buildRoute("/ajax-activate-avatar", routeValues);
};
AGS.Routes.AvatarDeleteAvatar = function(routeValues) {
    return AGS.Routes.buildRoute("/ajax-delete-avatar", routeValues);
};
AGS.Routes.AvatarDisableAvatar = function(routeValues) {
    return AGS.Routes.buildRoute("/ajax-disable-avatar", routeValues);
};
AGS.Routes.AvatarUploadAvatar = function(entityTypeID, entityID, routeValues) {
    return AGS.Routes.buildRoute("/avatar/{0}-{1}/upload".format(entityTypeID, entityID), routeValues);
};
AGS.Routes.CategoryPostGetData = function(postID, routeValues) {
    return AGS.Routes.buildRoute("/ajax/posts/{0}/get-data".format(postID), routeValues);
};
AGS.Routes.CommentGetCommentRevision = function(commentID, revisionNumber, routeValues) {
    return AGS.Routes.buildRoute("/comments/{0}/revisions/{1}/get.json".format(commentID, revisionNumber), routeValues);
};
AGS.Routes.CommentGetCommentRevisions = function(commentID, routeValues) {
    return AGS.Routes.buildRoute("/comments/{0}/revisions".format(commentID), routeValues);
};
AGS.Routes.CommentRatingModal = function(entityTypeID, entityID, routeValues) {
    return AGS.Routes.buildRoute("/comments/rating-modal/{0}-{1}".format(entityTypeID, entityID), routeValues);
};
AGS.Routes.CommentRevisionRollback = function(commentID, revisionNumber, routeValues) {
    return AGS.Routes.buildRoute("/comments/{0}/revisions/{1}/rollback".format(commentID, revisionNumber), routeValues);
};
AGS.Routes.CommonStorePreferences = function(routeValues) {
    return AGS.Routes.buildRoute("/ajax/store-preferences", routeValues);
};
AGS.Routes.CPAchievementDelete = function(id, routeValues) {
    return AGS.Routes.buildRoute("/cp/achievements/delete/{0}".format(id), routeValues);
};
AGS.Routes.CPAjaxAutoCompleteRouteName = function(routeValues) {
    return AGS.Routes.buildRoute("/cp/ajaxautocompleteroutename", routeValues);
};
AGS.Routes.CPAjaxAutoCompleteSiteName = function(routeValues) {
    return AGS.Routes.buildRoute("/cp/ajaxautocompletesitename", routeValues);
};
AGS.Routes.CPAjaxAutoCompleteTitle = function(routeValues) {
    return AGS.Routes.buildRoute("/cp/ajaxautocompletetitle", routeValues);
};
AGS.Routes.CPAnnouncementDelete = function(announcementID, routeValues) {
    return AGS.Routes.buildRoute("/cp/announcements/{0}/delete".format(announcementID), routeValues);
};
AGS.Routes.CPAnnouncementUnDelete = function(announcementID, routeValues) {
    return AGS.Routes.buildRoute("/cp/announcement/{0}/undelete".format(announcementID), routeValues);
};
AGS.Routes.CPCacheManagerInvalidateDataKey = function(routeValues) {
    return AGS.Routes.buildRoute("/cp/cache-manager/invalidate-data-key", routeValues);
};
AGS.Routes.CPCategoryContentBulkModeration = function(categoryID, routeValues) {
    return AGS.Routes.buildRoute("/cp/cms/folders/{0}/bulk-content-moderation".format(categoryID), routeValues);
};
AGS.Routes.CPDomainPolicyDelete = function(domainPolicyID, routeValues) {
    return AGS.Routes.buildRoute("/cp/domain-policy/{0}/delete".format(domainPolicyID), routeValues);
};
AGS.Routes.CPForumForm = function(parentForumID, displayOrder, routeValues) {
    return AGS.Routes.buildRoute("/cp/ajax-forum-form/{0}/{1}".format(parentForumID, displayOrder), routeValues);
};
AGS.Routes.CPGetNameForSite = function(routeValues) {
    return AGS.Routes.buildRoute("/cp/getnameforsite", routeValues);
};
AGS.Routes.CPGetSubNamespaces = function(namespaceID, routeValues) {
    return AGS.Routes.buildRoute("/ajax/localization/getsubnamespaces/{0}".format(namespaceID), routeValues);
};
AGS.Routes.CPGetWarningMessageTemplate = function(warningMessageID, routeValues) {
    return AGS.Routes.buildRoute("/cp/warning-messages/{0}/get-template.json".format(warningMessageID), routeValues);
};
AGS.Routes.CPLocalizationIndex = function(routeValues) {
    return AGS.Routes.buildRoute("/cp/localization", routeValues);
};
AGS.Routes.CPLocalizationPhraseEdit = function(phraseID, routeValues) {
    return AGS.Routes.buildRoute("/cp/localization/phrase/{0}".format(phraseID), routeValues);
};
AGS.Routes.CPPageGetUrl = function(parentFolderID, routeValues) {
    return AGS.Routes.buildRoute("/ajax/get-page-url/{0}".format(parentFolderID), routeValues);
};
AGS.Routes.CPPostGetUrl = function(categoryID, routeValues) {
    return AGS.Routes.buildRoute("/ajax/get-post-url/{0}".format(categoryID), routeValues);
};
AGS.Routes.CPPostRestoreRevision = function(postID, routeValues) {
    return AGS.Routes.buildRoute("/ajax/posts/{0}/restore-revision".format(postID), routeValues);
};
AGS.Routes.CPProfileFieldChangeGroup = function(routeValues) {
    return AGS.Routes.buildRoute("/cp/profile-fields/update-group", routeValues);
};
AGS.Routes.CPProfileFieldGroupUpdateDisplayOrder = function(routeValues) {
    return AGS.Routes.buildRoute("/cp/profile-fields-groups/update-display-order", routeValues);
};
AGS.Routes.CPProfileFieldUpdateDisplayOrder = function(routeValues) {
    return AGS.Routes.buildRoute("/cp/profile-fields/update-display-order", routeValues);
};
AGS.Routes.CPRoleDelete = function(entityTypeID, entityID, roleID, routeValues) {
    return AGS.Routes.buildRoute("/cp/user-groups/{0}-{1}/{2}/delete".format(entityTypeID, entityID, roleID), routeValues);
};
AGS.Routes.CPUserNonceBillingTransactions = function(userID, routeValues) {
    return AGS.Routes.buildRoute("/cp/users/{0}/nonce-billing-transactions".format(userID), routeValues);
};
AGS.Routes.FeedbackSend = function(routeValues) {
    return AGS.Routes.buildRoute("/send-feedback", routeValues);
};
AGS.Routes.ForumForumTopicsFilter = function(id, routeValues) {
    return AGS.Routes.buildRoute("/page-block/forum-filters/{0}".format(id), routeValues);
};
AGS.Routes.ForumGetAllForumSeenInfo = function(routeValues) {
    return AGS.Routes.buildRoute("/new-content/seeninfo", routeValues);
};
AGS.Routes.ForumGetForumLatestThreads = function(routeValues) {
    return AGS.Routes.buildRoute("/page-block/forum-filters/get-threads.json", routeValues);
};
AGS.Routes.ForumSetAllForumSeen = function(routeValues) {
    return AGS.Routes.buildRoute("/forums/set-all-forum-seen", routeValues);
};
AGS.Routes.ForumSetAllForumThreadSeen = function(forumID, routeValues) {
    return AGS.Routes.buildRoute("/forums/{0}/set-all-forum-thread-seen".format(forumID), routeValues);
};
AGS.Routes.ForumSetForumSeen = function(forumID, routeValues) {
    return AGS.Routes.buildRoute("/forums/{0}/set-forum-seen".format(forumID), routeValues);
};
AGS.Routes.InfractionsGetWarningDefinitionDescription = function(userID, points, routeValues) {
    return AGS.Routes.buildRoute("/user/{0}/warning/{1}/description.json".format(userID, points), routeValues);
};
AGS.Routes.InfractionsGetWarningDefinitionDescriptionByComment = function(userID, commentID, points, routeValues) {
    return AGS.Routes.buildRoute("/user/{0}/{1}/warning/{2}/description.json".format(userID, commentID, points), routeValues);
};
AGS.Routes.PollDelete = function(parentTypeID, parentID, pollID, routeValues) {
    return AGS.Routes.buildRoute("/polls/{0}-{1}/{2}/delete".format(parentTypeID, parentID, pollID), routeValues);
};
AGS.Routes.PollGetPollForm = function(forumID, index, routeValues) {
    return AGS.Routes.buildRoute("/polls/{0}/get-poll-form/{1}".format(forumID, index), routeValues);
};
AGS.Routes.PollHasUserVoted = function(pollID, routeValues) {
    return AGS.Routes.buildRoute("/polls/{0}/has-user-voted".format(pollID), routeValues);
};
AGS.Routes.PrivateMessageAjaxAutoCompleteContact = function(routeValues) {
    return AGS.Routes.buildRoute("/ajax/private-message-auto-complete", routeValues);
};
AGS.Routes.PrivateMessageCreateConversationFolder = function(conversationID, routeValues) {
    return AGS.Routes.buildRoute("/private-messages/{0}/create-folder".format(conversationID), routeValues);
};
AGS.Routes.PrivateMessageDeleteConversationFolder = function(conversationFolderID, routeValues) {
    return AGS.Routes.buildRoute("/private-messages/delete-folder/{0}".format(conversationFolderID), routeValues);
};
AGS.Routes.PrivateMessageIndex = function(routeValues) {
    return AGS.Routes.buildRoute("/private-messages", routeValues);
};
AGS.Routes.PrivateMessageInvite = function(conversationID, routeValues) {
    return AGS.Routes.buildRoute("/private-messages/{0}/invite".format(conversationID), routeValues);
};
AGS.Routes.PrivateMessageMoveToConversationFolder = function(conversationID, conversationFolderID, routeValues) {
    return AGS.Routes.buildRoute("/private-messages/{0}/move-to/{1}".format(conversationID, conversationFolderID), routeValues);
};
AGS.Routes.RatingGetUserRatings = function(routeValues) {
    return AGS.Routes.buildRoute("/get-user-ratings", routeValues);
};
AGS.Routes.ShoutboxAddMessage = function(commentID, routeValues) {
    return AGS.Routes.buildRoute("/shoutbox/{0}/add-message".format(commentID), routeValues);
};
AGS.Routes.ShoutboxDeleteMessage = function(commentID, routeValues) {
    return AGS.Routes.buildRoute("/shoutbox/{0}/delete-message".format(commentID), routeValues);
};
AGS.Routes.ShoutboxGetNewComments = function(routeValues) {
    return AGS.Routes.buildRoute("/shoutbox/get-new-comments", routeValues);
};
AGS.Routes.ShoutboxGetShowShoutboxPreference = function(routeValues) {
    return AGS.Routes.buildRoute("/shoutbox/get-show-shoutbox-preference", routeValues);
};
AGS.Routes.ShoutboxSaveShowShoutboxPreference = function(showShoutbox, routeValues) {
    return AGS.Routes.buildRoute("/shoutbox/save-show-shoutbox-preference/{0}".format(showShoutbox), routeValues);
};
AGS.Routes.SmileyGetSmilies = function(routeValues) {
    return AGS.Routes.buildRoute("/smilies/get-all", routeValues);
};
AGS.Routes.TagAjaxGetTags = function(routeValues) {
    return AGS.Routes.buildRoute("/ajax-get-tags", routeValues);
};
AGS.Routes.UserAjaxAutoCompleteUsername = function(routeValues) {
    return AGS.Routes.buildRoute("/autocomplete-username", routeValues);
};
AGS.Routes.UserGetUserSurrogateShortDetails = function(routeValues) {
    return AGS.Routes.buildRoute("/ajax-get-surrogate-details", routeValues);
};
AGS.Routes.UserWarningAcknowledgementChoice = function(choiceValue, routeValues) {
    return AGS.Routes.buildRoute("/warning-acknowledgement/choice/{0}".format(choiceValue), routeValues);
};
AGS.Routes.UserWarningAcknowledgementModal = function(routeValues) {
    return AGS.Routes.buildRoute("/warning-acknowledgement/get.json", routeValues);
};
AGS.Routes.UserContentBulkModeration = function(routeValues) {
    return AGS.Routes.buildRoute("/my-content/bulk-moderation", routeValues);
};
AGS.Routes.UserContentCreateFolder = function(routeValues) {
    return AGS.Routes.buildRoute("/my-content/create-folder", routeValues);
};
AGS.Routes.UserContentPostRestoreRevision = function(postID, revisionNumber, routeValues) {
    return AGS.Routes.buildRoute("/ajax/my-content/{0}/restore-revision/{1}".format(postID, revisionNumber), routeValues);
};
