﻿using System.Web.Mvc;
using Curse.AGS.Constants;
using Curse.AGS.Forums;
using Curse.AGS.Web.Helpers;
using Curse.AGS.Web.ViewModels.ForumEmailConfiguration;
using Curse.Cobalt.Data;
using Curse.Cobalt.IOC;
using Curse.Cobalt.Models;
using Curse.Cobalt.Web.ActionFilters;
using Curse.Cobalt.Web.Attributes;
using Curse.Cobalt.Web.Controllers;

namespace Curse.AGS.Web.Controllers
{
    public partial class CPController
    {
        [HttpGet]
        [RequireSitePermission(CobaltRoleBasedPermission.Site_ManageForum)]
        public ActionResult ForumEmailConfigIndex()
        {
            var iocContainter = new CobaltIOCContainer();
            return View(AGSViews.ForumEmailConfiguration.Index, new ForumEmailConfigurationIndexViewModel(iocContainter.GetInstance<IForumEmailMapRepository>()));
        }

        [HttpPost]
        [RequireSitePermission(CobaltRoleBasedPermission.Site_ManageForum)]
        public ActionResult ForumEmailConfigIndex(FormCollection formCollection)
        {
            var iocContainter = new CobaltIOCContainer();
            var vm = new ForumEmailConfigurationIndexViewModel(formCollection, iocContainter.GetInstance<IForumEmailMapRepository>());
            var form = vm.ForumEmailMapForm;
            if (!form.Validate())
            {
                return View(AGSViews.ForumEmailConfiguration.Index, vm);
            }

            using(var conn = new CobaltDataConnection())
            {
                form.Save(conn, null);
            }

            return this.RedirectToCPForumEmailConfigIndex(RedirectType.SeeOther);
        }

        [HttpPost]
        [AjaxCSRFTokenValidation]
        [RequireSitePermission(CobaltRoleBasedPermission.Site_ManageForum)]
        public ActionResult DeleteForumEmailConfig(int id, FormCollection formCollection)
        {
            new CobaltIOCContainer().GetInstance<IForumEmailMapRepository>().DeleteForumEmailMapByID(id);
            return this.RedirectToCPForumEmailConfigIndex(RedirectType.SeeOther);
        }

        [HttpGet]
        [RequireSitePermission(CobaltRoleBasedPermission.Site_ManageForum)]
        public ActionResult RoleEmailTriggerConfigIndex()
        {
            var iocContainter = new CobaltIOCContainer();
            return View(AGSViews.ForumEmailConfiguration.Index, new ForumEmailConfigurationIndexViewModel(iocContainter.GetInstance<IForumEmailMapRepository>()));
        }

        [HttpPost]
        [RequireSitePermission(CobaltRoleBasedPermission.Site_ManageForum)]
        public ActionResult RoleEmailTriggerConfigIndex(FormCollection formCollection)
        {
            var iocContainter = new CobaltIOCContainer();
            var vm = new ForumEmailConfigurationIndexViewModel(formCollection, iocContainter.GetInstance<IForumEmailMapRepository>());
            var form = vm.RoleEmailTriggerForm;
            if (!form.Validate())
            {
                return View(AGSViews.ForumEmailConfiguration.Index, vm);
            }

            using (var conn = new CobaltDataConnection())
            {
                form.Save(conn, null);
            }

            return this.RedirectToCPRoleEmailTriggerConfigIndex(RedirectType.SeeOther);
        }

        [HttpPost]
        [AjaxCSRFTokenValidation]
        [RequireSitePermission(CobaltRoleBasedPermission.Site_ManageForum)]
        public ActionResult DeleteRoleEmailTriggerConfig(int id, FormCollection formCollection)
        {
            new CobaltIOCContainer().GetInstance<IForumEmailMapRepository>().DeleteRoleEmailTriggerByID(id);
            return this.RedirectToCPRoleEmailTriggerConfigIndex(RedirectType.SeeOther);
        }
    }
}