﻿using System.Web.Mvc;
using Curse.AGS.Constants;
using Curse.AGS.LwaDirectedIds;
using Curse.AGS.Web.Forms;
using Curse.AGS.Web.Helpers;
using Curse.AGS.Web.ViewModels.LWAUserImporterExporter;
using Curse.Cobalt.Application;
using Curse.Cobalt.IOC;
using Curse.Cobalt.Models;
using Curse.Cobalt.Web.Attributes;
using Curse.Cobalt.Web.Controllers;

namespace Curse.AGS.Web.Controllers
{
    public partial class CPController
    {
        public CPController()
        {
            var container = new CobaltIOCContainer();
            this.LwaDirectedIdsExporter = container.GetInstance<ILwaDirectedIdsExporter>();
            this.LwaPermissionAssigner = container.GetInstance<ILwaPermissionAssigner>();
        }

        private ILwaDirectedIdsExporter LwaDirectedIdsExporter { get; }
        private ILwaPermissionAssigner LwaPermissionAssigner { get; }

        [HttpGet]
        [RequireSitePermission(CobaltRoleBasedPermission.Site_ManageUserAccounts)]
        public ActionResult BulkAssignPermissions()
        {
            return View(AGSViews.LWAUserImporterExporter.BulkAssignPermissions, new BulkAssignPermissionsViewModel());
        }

        [HttpPost]
        [RequireSitePermission(CobaltRoleBasedPermission.Site_ManageUserAccounts)]
        public ActionResult BulkAssignPermissions(FormCollection formCollection)
        {
            var form = new BulkAssignPermissionsForm(formCollection, Request.Files);
            var roles = form.GetRoles();

            LwaPermissionAssignerResult lwaPermissionAssignerResult;
            using (var fileInputStream = form.GetFileInputStream())
            {
                lwaPermissionAssignerResult = this.LwaPermissionAssigner.AssignPermissions(roles, fileInputStream, SiteContext.Current.Site);
            }

            var bulkAssignPermissionsViewModel = new BulkAssignPermissionsViewModel
            {
                Messages = lwaPermissionAssignerResult.Messages
            };

            return View(AGSViews.LWAUserImporterExporter.BulkAssignPermissions, bulkAssignPermissionsViewModel);
        }

        [HttpGet]
        [RequireSitePermission(CobaltRoleBasedPermission.Site_ManageUserAccounts)]
        public ActionResult ExportLwaDirectedIds()
        {
            return View(AGSViews.LWAUserImporterExporter.ExportLwaDirectedIds, new ExportLwaDirectedIdsViewModel());
        }

        [HttpPost]
        [RequireSitePermission(CobaltRoleBasedPermission.Site_ManageUserAccounts)]
        public ActionResult ExportLwaDirectedIds(FormCollection formCollection)
        {
            var form = new ExportLwaDirectedIdsForm(formCollection);

            var directedIdsResult = this.LwaDirectedIdsExporter.GetNewUsersInDateRange(form.StartDateTimeField.Value.Value,  form.EndDateTimeField.Value.Value);

            if (!directedIdsResult.Success)
            {
                var exportLwaDirectedIdsViewModel = new ExportLwaDirectedIdsViewModel(formCollection)
                {
                    Message = directedIdsResult.Message
                };

                return View(AGSViews.LWAUserImporterExporter.ExportLwaDirectedIds, exportLwaDirectedIdsViewModel);
            }

            return File(directedIdsResult.DirectedIdsCsvStream, "text/csv", "directedIds.csv");
        }
    }
}
