﻿using System.Web.Mvc;
using Curse.AGS.Constants;
using Curse.AGS.Users.Importers;
using Curse.AGS.Web.Forms;
using Curse.AGS.Web.Helpers;
using Curse.AGS.Web.ViewModels.UserImporter;
using Curse.Cobalt.Application;
using Curse.Cobalt.Models;
using Curse.Cobalt.Navigation;
using Curse.Cobalt.Web.Attributes;
using Curse.Cobalt.Web.Routing;

namespace Curse.AGS.Web.Controllers
{
    public partial class CPController : Cobalt.Web.Controllers.CPController
    {
        static CPController()
        {
            AddNavigationItem(() =>
            {
                var menu = new LinkNavigationItem(L.ToDo("AGS"), null);
                menu.AddSubItem(new LinkNavigationItem(L.ToDo("Import Users"), RouteContext.Current.UrlHelper.CPTwitchUserImport()));
                // I hate putting this here but see no way around it for now.
                menu.AddSubItem(new LinkNavigationItem(L.ToDo("Forum Email Configuration"), RouteContext.Current.UrlHelper.CPForumEmailConfigIndex()));

                if (GlobalSetting.Get<bool>("AgsFeatureFlag", () => false))
                {
                    menu.AddSubItem(new LinkNavigationItem(L.ToDo("Export LWA Directed IDs"), RouteContext.Current.UrlHelper.CPExportLwaDirectedIds()));
                    menu.AddSubItem(new LinkNavigationItem(L.ToDo("Bulk Assign Permissions"), RouteContext.Current.UrlHelper.CPBulkAssignPermissions()));
                }
                return menu;
            });
        }

        private readonly IUserImporter _userImporter;
        public CPController(IUserImporter userImporter)
        {
            _userImporter = userImporter;
        }


        [RequireSitePermission(CobaltRoleBasedPermission.Site_ManageUserAccounts)]
        [HttpGet]
        public ActionResult TwitchUserImport()
        {
            return View(AGSViews.UserImporter.Index, new UserImporterViewModel());
        }

        [RequireSitePermission(CobaltRoleBasedPermission.Site_ManageUserAccounts)]
        [HttpPost]
        public ActionResult TwitchUserImport(FormCollection formCollection)
        {
            var form = new UserImporterForm(formCollection, Request.Files);
            var result = _userImporter.ImportAndAssignRoles(form.GetFileInputStream(), form.GetRoles(), SiteContext.Current.Site);
            return View(result.ImportSucceeded ? AGSViews.UserImporter.Result : AGSViews.UserImporter.Error, new UserImporterResultViewModel(result));
        }
    }
}