﻿using System.Web.Mvc;
using Curse.Cobalt.Application;
using Curse.Cobalt.Constants;
using Curse.Cobalt.Models;
using Curse.Cobalt.Web.Controllers;
using Curse.Cobalt.Web.OutputCaching;
using Curse.Cobalt.Web.ViewModels;

namespace Curse.AGS.Web.Controllers
{
    public class HomeController : BaseController
    {
        [HttpGet]
        [SupplantOutputCache(VaryByCustom = "Region", VaryByParam = "page")]
        public ActionResult Index()
        {
            switch (SiteContext.Current.Site.IndexDisplayMode)
            {
                case SiteIndexDisplayMode.ForumIndex:
                    var viewModel = new ForumIndexViewModel { BodyCssClass = "body-forum body-forum-index" };
                    return View(CobaltViews.Forum.Index, viewModel);
                //return new ForumController().Index();
                default:
                    return new CategoryController(Url).Details("");
            }
        }
    }
}
