﻿using System;
using System.Linq;
using Curse.AGS.Constants;
using Curse.AGS.Forums;
using Curse.AGS.Models;
using Curse.AGS.Web.ViewModels.ForumEmailConfiguration;
using Curse.Cobalt.Application;
using Curse.Cobalt.Models;
using Curse.Cobalt.Web.Helpers;
using Curse.Mailer;

namespace Curse.AGS.Web.Events
{
    public class CommentCreatedEventInitializer
    {
        public static void RegisterCommentCreatedEvent(IForumEmailMapRepository forumEmailMapRepository)
        {
            Comment.Created += (sender, e) => { SendEmail(forumEmailMapRepository, e.Entity); };
        }

        private static void SendEmail(IForumEmailMapRepository forumEmailMapRepository, Comment comment)
        {
            try
            {
                var forum = ((ForumThread) comment.Entity)?.Forum;
                var forumHasEmailMapped = forum != null && forumEmailMapRepository.ForumHasEmailMapped(forum.ID);
                var userTriggersEmail = UserTriggersEmail(comment.Author);
                if (!forumHasEmailMapped || !userTriggersEmail)
                {
                    return;
                }

                var map = forumEmailMapRepository.GetForumEmailMap(forum.ID);
                MailProvider.Instance.SendFormattedMessage(GetSiteEmail(comment), map.Email, FormatEmailSubject(comment), FormatEmailBody(comment), FormatEmailBody(comment));
            }
            catch (Exception ex)
            {
                CobaltLogger.Instance.LogException(ex);
            }
        }

        private static bool UserTriggersEmail(User user)
        {
            return (from a in user.RoleAssignmentQuery join t in AGSRoleEmailTrigger.Query on a.RoleID equals t.RoleID select t).Any();
        }

        private static string GetSiteEmail(Comment comment)
        {
            return comment.Site.SiteMailAddress;
        }

        private static string FormatEmailSubject(Comment comment)
        {
            var forumThread = (ForumThread) comment.Entity;
            return $"New reply in \"{forumThread.Title}\"";
        }

        private static string FormatEmailBody(Comment comment)
        {
            return PartialHelper.RenderPartialAsString(AGSPartialViews.ForumEmailConfiguration.Email, new ForumEmailViewModel(comment));
        }
    }
}