﻿using System.Web.Mvc;
using Curse.Cobalt;
using Curse.Cobalt.AmazonAuth;
using Curse.Cobalt.Web.Forms;

namespace Curse.AGS.Web.Forms.AmazonAuth
{
    public class SetDisplayNameForm : Form
    {
        public SetDisplayNameForm(AmazonUser amazonUser, FormCollection formCollection) : base(formCollection)
        {
            DisplayNameField = new TextField(this)
            {
                Name = "display-name",
                Label = CL.ToDo("Set Your Display Name"),
                Validators = Validator<string>.NicknameValidators(true)
            };

            AmazonUserIDField = new TextField(this)
            {
                Name = "user-id",
                IsHidden = true,
                Default = amazonUser?.ID
            };

            AmazonAccessToken = new TextField(this)
            {
                Name = "amazon-access-token",
                IsHidden = true,
                Default = amazonUser?.AccessToken
            };

            AmazonRefreshToken = new TextField(this)
            {
                Name = "amazon-refresh-token",
                IsHidden = true,
                Default = amazonUser?.RefreshToken
            };

            Name = new TextField(this)
            {
                Name = "amazon-name",
                IsHidden = true,
                Default = amazonUser?.Name
            };

            Email = new TextField(this)
            {
                Name = "amazon-email",
                IsHidden = true,
                Default = amazonUser?.Email
            };

        }

        public TextField DisplayNameField { get; }
        public TextField AmazonUserIDField { get; }
        public TextField AmazonAccessToken { get; }
        public TextField AmazonRefreshToken { get; }
        public TextField Name { get; set; }
        public TextField Email { get; set; }

        public AmazonUser GetAmazonUser()
        {
            return new AmazonUser
            {
                ID = AmazonUserIDField.Value,
                DisplayName = DisplayNameField.Value,
                AccessToken = AmazonAccessToken.Value,
                RefreshToken = AmazonAccessToken.Value,
                Name = Name.Value,
                Email = Email.Value
            };
        }
    }
}