﻿using System;
using System.Web.Mvc;
using Curse.Cobalt;
using Curse.Cobalt.Web.Forms;

namespace Curse.AGS.Web.Forms
{
    public class ExportLwaDirectedIdsForm : Form
    {
        public ExportLwaDirectedIdsForm(FormCollection formCollection) : base(formCollection)
        {
            StartDateTimeField = new DateTimeField(this)
            {
                Name = "start-date",
                Label = CL.ToDo("Start Date"),
                Default = DateTime.Now.AddDays(-1),
                CssClasses = new []{ "inline-textboxes" },
                Validators = new []
                {
                    Validators.Required<DateTime?>()
                }
            };

            EndDateTimeField = new DateTimeField(this)
            {
                Name = "end-date",
                Label = CL.ToDo("End Date"),
                Default = DateTime.Now,
                CssClasses = new[] { "inline-textboxes" },
                Validators = new[]
                {
                    Validators.Required<DateTime?>()
                }
            };
        }

        public DateTimeField StartDateTimeField { get; set; }

        public DateTimeField EndDateTimeField { get; set; }
    }
}