﻿using Curse.AGS.Forums;
using Curse.AGS.Models;
using Curse.Cobalt;
using Curse.Cobalt.Application;
using Curse.Cobalt.Data;
using Curse.Cobalt.Models;
using Curse.Cobalt.Web.Forms;
using System.Linq;
using System.Web.Mvc;

namespace Curse.AGS.Web.Forms
{
    public class ForumEmailMapForm : Form<AGSForumEmailMap>
    {
        private readonly IForumEmailMapRepository _forumEmailMapRepository;
        public ForumEmailMapForm(FormCollection formCollection, IForumEmailMapRepository forumEmailMapRepository) : base(formCollection)
        {
            _forumEmailMapRepository = forumEmailMapRepository;

            ForumEmailMapField = new ModelChoiceField<Forum>(this)
            {
                Name = "forum",
                Label = CL.ToDo("Forum to Watch"),
                RenderStyle = ChoiceFieldRenderStyle.Select,
                Choices = forumEmailMapRepository.GetForumsAvailableForMappingBySiteID(SiteContext.Current.SiteID).Select(f => new Choice<Forum>(f, f.Label)),
                Validators = new[]
                {
                    Validators.Required<Forum>()
                }
            };

            EmailField = new TextField(this)
            {
                Name = "email",
                Label = CL.ToDo("Email to Notify"),
                Validators = new[]
                {
                    Validators.Required<string>(),
                    Validators.Email(),
                    Validators.NoWhitespace()
                }
            };
        }

        public ModelChoiceField<Forum> ForumEmailMapField { get; }
        public TextField EmailField { get; }

        protected override AGSForumEmailMap UpdateEntity(CobaltDataConnection conn, AGSForumEmailMap entity, bool saveToDatabase)
        {
            _forumEmailMapRepository.SaveForumEmailMap(new AGSForumEmailMap
            {
                Forum = ForumEmailMapField.Value,
                Email = EmailField.Value
            });
            return entity;
        }
    }
}