﻿using System.Linq;
using System.Web.Mvc;
using Curse.AGS.Forums;
using Curse.AGS.Models;
using Curse.Cobalt;
using Curse.Cobalt.Application;
using Curse.Cobalt.Data;
using Curse.Cobalt.Models;
using Curse.Cobalt.Web.Forms;

namespace Curse.AGS.Web.Forms
{
    public class RoleEmailTriggerMapForm : Form<AGSRoleEmailTrigger>
    {
        private readonly IForumEmailMapRepository _roleEmailTriggerMapRepository;
        public RoleEmailTriggerMapForm(FormCollection formCollection, IForumEmailMapRepository roleEmailTriggerMapRepository) : base(formCollection)
        {
            _roleEmailTriggerMapRepository = roleEmailTriggerMapRepository;

            RoleEmailTriggerMapField = new ModelChoiceField<Role>(this)
            {
                Name = "role",
                Label = CL.ToDo("User Group to Watch"),
                RenderStyle = ChoiceFieldRenderStyle.Select,
                Choices = roleEmailTriggerMapRepository.GetRolesAvailableForMappingBySiteID(SiteContext.Current.SiteID).Select(f => new Choice<Role>(f, f.Label)),
                Validators = new[]
                {
                    Validators.Required<Role>()
                }
            };
        }

        public ModelChoiceField<Role> RoleEmailTriggerMapField { get; }

        protected override AGSRoleEmailTrigger UpdateEntity(CobaltDataConnection conn, AGSRoleEmailTrigger entity, bool saveToDatabase)
        {
            _roleEmailTriggerMapRepository.SaveRoleEmailTrigger(new AGSRoleEmailTrigger
            {
                Role = RoleEmailTriggerMapField.Value,
            });
            return entity;
        }
    }
}