﻿using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Curse.Cobalt;
using Curse.Cobalt.Application;
using Curse.Cobalt.Extensions;
using Curse.Cobalt.Models;
using Curse.Cobalt.Web.Forms;

namespace Curse.AGS.Web.Forms
{
    public class UserImporterForm : Form
    {
        public UserImporterForm(FormCollection formCollection, HttpFileCollectionBase files) : base(formCollection, files)
        {
            FileField = new FileField(this)
            {
                Name = "users-file",
                Label = CL.ToDo("Users to Import (.csv)"),
                Validators = new[]
                {
                    Validators.Required<HttpPostedFileBase>(),
                    Validators.MimeType(new[] { "application/octet-stream", "text/csv" })
                }
            };

            var permissionableEntity = SiteContext.Current.Site;
            var availableRoles = permissionableEntity.RoleRoot.Roles.Where(r => !r.IsGenerated && r.RoleCategory.Name != "Administration").ToArray();
            var choices = availableRoles.Select(r => new Choice<Role>(r, r.Name.MockLocalizedTranslation(true), r.Description.MockLocalizedTranslation(true))).OrderBy(p => p.Value.RankLevel).GroupBy(p => p.Value.RoleCategory.Label);
            Roles = new ModelMultipleChoiceField<Role>(this)
            {
                Name = "roles",
                GroupedChoices = choices,
                RenderStyle = ChoiceFieldRenderStyle.Radio,
                VerifyValuesAreInChoices = true
            };
        }

        public FileField FileField { get; }
        public ModelMultipleChoiceField<Role> Roles { get; }

        public Stream GetFileInputStream()
        {
            return FileField.Value.InputStream;
        }

        public IEnumerable<Role> GetRoles()
        {
            return Roles.Value;
        }
    }
}