﻿using System.Web.Routing;
using Curse.Cobalt.Application;
using Curse.Cobalt.Web;
using Curse.Cobalt.Web.ViewEngines;
using Curse.Cobalt.Web.Extensions;
using System.Diagnostics;
using Curse.AGS.Web.Controllers;
using Curse.AGS.Forums;
using Curse.Cobalt.IOC;
using Curse.AGS.Web.Events;
using System.Web.Optimization;
using Curse.AGS.SessionManagement;
using Curse.AGS.Web.Controllers;
using Curse.Cobalt.AmazonAuth;
using Curse.Cobalt.Models;
using Curse.Cobalt.SessionManagement.ExternalSessionValidation;

namespace Curse.AGS.Web
{
    public class AGSMvcApplication : CobaltMvcApplication
    {
        protected void RegisterRoutes(RouteCollection routes)
        {
            routes.MapRoute<HomeController>(c => c.Index(), "");
            RegisterDefaultRoutes(routes);

            routes.MapRoute<CPController>(c => c.TwitchUserImport(), "cp/import-users");
            routes.MapRoute<CPController>(c => c.ForumEmailConfigIndex(), "cp/configure-forum-email");
            routes.MapRoute<CPController>(c => c.RoleEmailTriggerConfigIndex(), "cp/configure-role-email-trigger");
            routes.MapRoute<CPController>(c => c.DeleteForumEmailConfig(0, null), "cp/configure-forum-email/{id}/delete");
            routes.MapRoute<CPController>(c => c.DeleteRoleEmailTriggerConfig(0, null), "cp/configure-role-site-email-trigger/{id}/delete");
            routes.MapRoute<CPController>(c => c.BulkAssignPermissions(), "cp/bulk-assign-permissions");
            routes.MapRoute<CPController>(c => c.ExportLwaDirectedIds(), "cp/export-lwa-directed-ids");

            routes.MapRoute<AmazonRedirectController>(c => c.RefRedirect(string.Empty), "ref={refTag}");
            routes.MapRoute<AmazonRedirectController>(c => c.RefRedirectWithParameters(string.Empty, string.Empty), "ref={refTag}?{refParams}");

            routes.MapRoute<AmazonAuthenticationController>(c => c.LogIn(string.Empty), ExternalAuthProvider.AmazonLogin);
            routes.MapRoute<AmazonAuthenticationController>(c => c.TokenCallback(string.Empty, string.Empty, string.Empty, string.Empty), "amazon-login/token");
            routes.MapRoute<AmazonAuthenticationController>(c => c.CreateUser(null), "amazon-login/create-user");

            RegisterCatchAllRoute(routes);
        }

        protected override void ApplicationStartInner()
        {
            CommentCreatedEventInitializer.RegisterCommentCreatedEvent(new CobaltIOCContainer().GetInstance<IForumEmailMapRepository>());

            CobaltApplication.HttpApplication = this;

            CobaltLogger.Instance.WriteToEventLog("AGS Application Starting", EventLogEntryType.Information);

            new AppBundleConfig().RegisterBundles(BundleTable.Bundles);

            var ioc = new CobaltIOCContainer();
            ExternalSessionValidatorFactory.RegisterExternalSessionValidator("Amazon", new AmazonSessionValidator(ioc.GetInstance<IAmazonApi>()));

            RegisterRoutes(RouteTable.Routes);
            RegisterDefaultSearchProviders();

            System.Web.Mvc.ViewEngines.Engines.Clear();
            System.Web.Mvc.ViewEngines.Engines.Add(new CobaltViewEngine());

            CobaltLogger.Instance.WriteToEventLog("AGS Application Started", EventLogEntryType.Information);
        }

        protected override void RegisterIOC()
        {
            base.RegisterIOC();
            IOCConfig.Register();
        }
    }
}