﻿using Curse.AGS.Constants;
using Curse.AGS.Models;
using Curse.Cobalt.Localization;
using Curse.Cobalt.Web.Listings;

namespace Curse.AGS.Web.ListingDefinitions
{
    public class ForumEmailListingDefinition
    {
        private static ListingColumn<AGSForumEmailMap> ForumNameColumn = new ListingColumn<AGSForumEmailMap>()
        {
            Name = LazyLocalizedTranslation.ToDo("Forum")
        }.SetSortColumn(b => b.Forum.Title);

        private static ListingColumn<AGSForumEmailMap> EmailColumn = new ListingColumn<AGSForumEmailMap>()
        {
            Name = LazyLocalizedTranslation.ToDo("Email")
        };

        private static ListingColumn<AGSForumEmailMap> ForumEmailAdminColumn = new ListingColumn<AGSForumEmailMap>
        {
            Name = LazyLocalizedTranslation.Empty
        };

        public static ListingDefinition<AGSForumEmailMap> ForumEmailIndex = new ListingDefinition<AGSForumEmailMap>()
        {
            Name = "forum-email-maps",
            ItemsPerPage = 25,
            ProcessingLocation = ListingProcessingLocation.ServerSide,
            RowRenderer = new ListingRowRenderer<AGSForumEmailMap>(AGSPartialViews.ForumEmailConfiguration.ForumEmailListing)
        }
        .AddColumn(ForumNameColumn)
        .AddColumn(EmailColumn)
        .AddColumn(ForumEmailAdminColumn);

        private static readonly ListingColumn<AGSRoleEmailTrigger> RoleNameColumn = new ListingColumn<AGSRoleEmailTrigger>
        {
            Name = LazyLocalizedTranslation.ToDo("User Group")
        }.SetSortColumn(b => b.Role.Name);

        private static readonly ListingColumn<AGSRoleEmailTrigger> RoleEmailTriggerAdminColumn = new ListingColumn<AGSRoleEmailTrigger>
        {
            Name = LazyLocalizedTranslation.ToDo("Remove User Group")
        };

        public static ListingDefinition<AGSRoleEmailTrigger> RoleEmailTriggerIndex = new ListingDefinition<AGSRoleEmailTrigger>
        {
            Name = "role-email-trigger-maps",
            ItemsPerPage = 25,
            ProcessingLocation = ListingProcessingLocation.ServerSide,
            RowRenderer = new ListingRowRenderer<AGSRoleEmailTrigger>(AGSPartialViews.ForumEmailConfiguration.RoleEmailTriggerListing)
        }
        .AddColumn(RoleNameColumn)
        .AddColumn(RoleEmailTriggerAdminColumn);
    }
}