﻿using System.Linq;
using System.Web.Mvc;
using Curse.AGS.Forums;
using Curse.AGS.Models;
using Curse.AGS.Web.Forms;
using Curse.AGS.Web.ListingDefinitions;
using Curse.Cobalt;
using Curse.Cobalt.Application;
using Curse.Cobalt.Models;
using Curse.Cobalt.Web.Forms;
using Curse.Cobalt.Web.Listings;
using Curse.Cobalt.Web.ViewModels;

namespace Curse.AGS.Web.ViewModels.ForumEmailConfiguration
{
    public class ForumEmailConfigurationIndexViewModel : BaseControlPanelViewModel
    {
        public ForumEmailConfigurationIndexViewModel(IForumEmailMapRepository forumEmailMapRepository)
            :this(null, forumEmailMapRepository)
        {
        }

        public ForumEmailConfigurationIndexViewModel(FormCollection formCollection, IForumEmailMapRepository forumEmailMapRepository)
        {
            ObjectPath = new[] { CL.ToDo("Forum Email Configuration") };
            ForumEmailMapForm = new ForumEmailMapForm(formCollection, forumEmailMapRepository);
            RoleEmailTriggerForm = new RoleEmailTriggerMapForm(formCollection, forumEmailMapRepository);
            ForumsListing = ForumEmailListingDefinition.ForumEmailIndex.Create(AGSForumEmailMap.Query);
            TriggerListing = ForumEmailListingDefinition.RoleEmailTriggerIndex.Create(AGSRoleEmailTrigger.Query);
            RoleTriggersExist = (from a in Role.GetQueryByEntityTypeIDAndEntityID(Site.ModelTypeID, SiteContext.Current.SiteID)
                                join t in AGSRoleEmailTrigger.Query
                                on a.ID equals t.RoleID select t)
                                .Any();
        }

        public bool RoleTriggersExist { get; }
        public Form<AGSForumEmailMap> ForumEmailMapForm { get; }
        public Form<AGSRoleEmailTrigger> RoleEmailTriggerForm { get; }
        public Listing<AGSForumEmailMap> ForumsListing { get; }
        public Listing<AGSRoleEmailTrigger> TriggerListing { get; }
    }
}