﻿using System;
using Curse.Cobalt.Models;
using Curse.Cobalt.Web.Extensions;
using Curse.Cobalt.Web.ModelBinding;

namespace Curse.AGS.Web.ViewModels.ForumEmailConfiguration
{
    public class ForumEmailViewModel
    {
        public ForumEmailViewModel(Comment comment)
        {
            var thread = ((ForumThread)comment.Entity);
            var forum = thread.Forum;

            SiteUrl = forum.Site.DomainLink;
            ForumName = forum.Title;
            ForumSlug = forum.SlugPath;
            ThreadName = thread.Title;
            ThreadSlug = thread.GetIDSlugPair();
            Author = comment.Author;
            AuthorName = comment.Author.Username;
            CommentDate = comment.DateCreated;
            CommentDisplayIndex = comment.DisplayIndex;
            Body = comment.Body;
            IsNewThread = thread.StartingCommentID == comment.ID;
        }

        public string SiteUrl { get; }
        public string ForumName { get; }
        public string ForumSlug { get; }
        public string ThreadName { get; }
        public IDSlugPair ThreadSlug { get; }
        public User Author { get; }
        public string AuthorName { get; }
        public DateTime CommentDate { get; }
        public int? CommentDisplayIndex { get; }
        public string Body { get; }
        public bool IsNewThread { get; }

    }
}