﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<PageBlockViewModel>" %>
<% ScriptHelper.AddScriptDependency(CJ.Analytics); %>

<%
    var mainLinkURL = GlobalSetting.Get<string>("Footer.MainLink.URL", () => "/");
    var mainLinkTitle = GlobalSetting.Get<string>("Footer.MainLink.Title", () => SiteContext.Current.Site.Title);
%>

<div class="site-footer-links">
    <div class="site-footer-links-logo">
        <a href="<%= mainLinkURL %>" target="_blank" class="logo"><%= mainLinkTitle %></a>
    </div>
    <ul class="site-footer-links-list">
        <li class="site-footer-links-list-item">
            <a href="https://games.amazon.com/legal" target="_blank" class="about">
                <%= CL.ToDo("Terms of Use") %>
            </a>
        </li>
        <li class="site-footer-links-list-item">
            <a href="https://games.amazon.com/privacy" target="_blank" class="terms-of-service">
                <%= CL.ToDo("Privacy Notice") %>
            </a>
        </li>
    </ul>
    <div class="site-footer-links-copyright">
        &copy; <%= string.Format("{0}, Amazon.com, Inc. or its affiliates. All rights reserved.", DateTime.UtcNow.Year) %>
    </div>
</div>
<a data-ga-click-event-tracking-category="Mobile View" id="responsive-footer-button" class="rs-link rs-link-to-responsive">Mobile View</a>