﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl" %>



<div class="site-interactions">
    <div class="site-interactions-groups">
        <div class="site-interactions-group site-interactions-group-logo">
            <a href="/" class="logo"><%= SiteContext.Current.Site.Label %></a>
        </div>
        <div class="site-interactions-group site-interactions-group-search">
            <div class="site-search">
                <% Html.RenderPartial_Search_SearchBar(); %>
            </div>
        </div>
        <div class="site-interactions-group site-interactions-group-user">
            <div class="user-interactions">
                <% if (!UserContext.Current.IsAnonymous) {
                       var hasExtraActions = SiteContext.Current.Site.CanViewControlPanel()
                                             || SiteContext.Current.Site.CanModerateReports()
                                             || SiteContext.Current.Site.CanViewAppeals()
                                             || SiteContext.Current.Site.CanDisplayUserCounts();
                %>
                    <div class="user-interactions-profile">
                        <div class="user-interactions-profile-preview">
                            <img src="<%= Html.Supplant(() => UserContext.Current.User.AvatarUrl) %>" alt="Avatar" class="user-interactions-profile-img" />
                            <span class="user-interactions-profile-nickname"><%= Html.Supplant(() => UserContext.Current.User.UserProfile.Nickname) %></span>
                            <a href="<%= Html.Supplant(() => RouteContext.Current.UrlHelper.Details(UserContext.Current.User)) %>" class="user-interactions-profile-preview-link"></a>
                        </div>
                            <ul class="user-interactions-profile-menu">
                                <% if (SiteContext.Current.CanAccess())
                                   { %>
                                <li class="user-interactions-profile-menu-item"><a href="<%= Html.Supplant(() => RouteContext.Current.UrlHelper.Details(UserContext.Current.User)) %>" class="user-interactions-profile-menu-link"><%= CL.Global.Common.MyProfile %></a></li>
                                <% Html.RenderPartial_Shared_MyAccountApplication(); %>
                                <li class="user-interactions-profile-menu-item"><a class="user-interactions-profile-menu-link" href="<%= RouteContext.Current.UrlHelper.UserEdit() %>"><%= CL.Global.Netbar.My_Account %></a></li>
                                <% if (SiteContext.Current.Site.HasModule("UserContent")) { %>
                                    <%= Html.Supplant(() => SiteContext.Current.Site.HasModule("UserContent") ? new HtmlString("<li class=\"user-interactions-profile-menu-item\"><a class=\"user-interactions-profile-menu-link\" href=\"" + RouteContext.Current.UrlHelper.UserContentIndex(string.Empty) + "\">"+ CL.Global.Netbar.My_Content + "</a></li>") : new HtmlString(""))%>
                                <% } %>
                                <li class="user-interactions-profile-menu-item"><a class="user-interactions-profile-menu-link" href="<%= RouteContext.Current.UrlHelper.ForumRecentlyUpdatedForumThreads() %>?filter-date-range-type=4&filter-association-type=3"><%= CL.Global.Netbar.My_Threads %></a></li>
                                <% } %>
                                <li class="user-interactions-profile-menu-item">
                                    <form name="logoutForm" method="post" action="<%= Url.AuthenticationLogOut() %>">
                                        <button class="user-interactions-profile-menu-btn"><%= CL.Global.Netbar.Sign_Out %></button>
                                    </form>
                                </li>
                            </ul>
                    </div>
                    <%  var languages = Language.OrderedEnabled.OrderBy(x => x.CultureCode).ToArray();
                        if (languages.Length > 1)
                        { %>
                        <div class="user-interactions-language">
                            <div class="user-interactions-language-current"><%= UserPreferences.Current.Language.CultureCode.ToUpper() %></div>
                            <ul class="user-interactions-language-menu">
                                <%  foreach (var lang in languages)
                                    { %>
                                    <li class="user-interactions-language-menu-item <%= lang == UserContext.Current.Language ? "active" : "" %>" onclick="Cobalt.User.setLanguage(<%= lang.ID %>)"><%= lang.CultureCode.ToUpper() %></li>
                                <%  } %>
                            </ul>
                        </div>
                    <% } %>
                    <% if (SiteContext.Current.CanAccess())
                       { %>
                    <div class="user-interactions-quick">
                        <% if (SiteContext.Current.Site.HasModule("Notifications"))
                           { %>
                            <a class="user-interactions-quick-link user-interactions-quick-notifications j-netbar-link" href="<%= RouteContext.Current.UrlHelper.NotificationNotificationsList() %>" data-ajax-url="<%= RouteContext.Current.UrlHelper.NotificationMinimalNotifications() %>"><i class="fa fa-bell"></i><%= Html.Supplant(() => UserContext.Current.User.GetUnreadNotificationCountForSite(SiteContext.Current.Site) > 0 ? new HtmlString("<span class=\"option-count\">" + UserContext.Current.User.GetUnreadNotificationCountForSite(SiteContext.Current.Site) + "</span>") : new HtmlString("")) %></a>
                        <% } %>
                        <% if (SiteContext.Current.Site.HasModule("PrivateMessaging"))
                           { %>
                            <% var unreadMessageCount = Conversation.GetUnreadConversationCountForSiteIDAndUserID(SiteContext.Current.SiteID, UserContext.Current.UserID, UserContext.Current.ShowHellBanContent); %>
                            <a class="user-interactions-quick-link user-interactions-quick-messages" data-message-count="<%= Html.Supplant(() => unreadMessageCount.ToString()) %>" href="<%= RouteContext.Current.UrlHelper.PrivateMessageIndex() %>"><i class="fa fa-envelope"></i><%= Html.Supplant(() => unreadMessageCount > 0 ? new HtmlString("<span class=\"option-count\">" + unreadMessageCount + "</span>") : new HtmlString("")) %></a>
                        <% } %>
                        <% if (hasExtraActions)
                           { %>
                            <span class="user-interactions-quick-extra">
                                <% if (SiteContext.Current.Site.CanViewControlPanel())
                                   { %>
                                    <a class="user-interactions-quick-link user-interactions-quick-cp" href="<%= RouteContext.Current.UrlHelper.CPIndex() %>"><i class="fa fa-wrench"></i></a>
                                <% } %>
                                <% if (SiteContext.Current.Site.CanModerateReports())
                                   { %>
                                    <a class="user-interactions-quick-link user-interactions-quick-reports" href="<%= RouteContext.Current.UrlHelper.CPReportIndex() %>"><i class="fa fa-flag"></i><%= Html.Supplant(() => Report.GetActiveReportCount() > 0 ? new HtmlString("<span class=\"option-count\">" + Report.GetActiveReportCount() + "</span>") : new HtmlString("")) %></a>
                                <% } %>
                                <% if (SiteContext.Current.Site.CanViewAppeals())
                                   { %>
                                    <a class="user-interactions-quick-link user-interactions-quick-appeals" href="<%= RouteContext.Current.UrlHelper.CPAppealIndex() %>"><i class="fa fa-gavel"></i><%= Html.Supplant(() => InfractionAppeal.GetActiveAppealsCount() > 0 ? new HtmlString("<span class=\"option-count\">" + InfractionAppeal.GetActiveAppealsCount() + "</span>") : new HtmlString("")) %></a>
                                <% } %>
                                <% if (SiteContext.Current.Site.CanDisplayUserCounts())
                                   { %>
                                    <%= Html.Supplant(() =>
                                        {
                                            Curse.Cobalt.Web.UserTracking.UserStatistics stats = SiteContext.Current.Site.GetUserStatistics();
                                            return new HtmlString("<a class=\"user-interactions-quick-link user-interactions-quick-users\" href=\"" + RouteContext.Current.UrlHelper.MemberListIndex() + "?filter-is-online=y\"><i class=\"fa fa-users\"></i>" + stats.OnlineRegisteredUserCount.ToFriendlyString(0, "0") + " / " + stats.OnlineAnonymousUserCount.ToFriendlyString(0, "0") + "</a>");
                                        }) %>
                                <% } %>
                            </span>
                        <% } %>
                    </div>
                    <%
                        }
                        if (hasExtraActions) { %>
                        <div class="user-interactions-extra">
                            <div class="user-interactions-extra-preview"><i class="fa fa-cog"></i><%= Html.Supplant(() => Report.GetActiveReportCount() > 0 ? new HtmlString("<span class=\"option-count\">" + Report.GetActiveReportCount() + "</span>") : new HtmlString("")) %></div>
                            <div class="user-interactions-extra-menu">
                                <ul>
                                    <% if (SiteContext.Current.Site.CanViewControlPanel()) { %>
                                        <li class="user-interactions-extra-menu-item user-interactions-extra-cp"><a class="user-interactions-extra-menu-link" href="<%= RouteContext.Current.UrlHelper.CPIndex() %>">Control Panel</a></li>
                                    <% } %>
                                    <% if (SiteContext.Current.Site.CanModerateReports()) { %>
                                        <li class="user-interactions-extra-menu-item user-interactions-extra-reports"><a class="user-interactions-extra-menu-link" href="<%= RouteContext.Current.UrlHelper.CPReportIndex() %>"><%= Html.Supplant(() => Report.GetActiveReportCount() > 0 ? new HtmlString("<span class=\"option-count\">" + Report.GetActiveReportCount() + "</span>") : new HtmlString("")) %>Reports</a></li>
                                    <% } %>
                                    <% if (SiteContext.Current.Site.CanViewAppeals()) { %>
                                        <li class="user-interactions-extra-menu-item user-interactions-extra-appeals"><a class="user-interactions-extra-menu-link" href="<%= RouteContext.Current.UrlHelper.CPAppealIndex() %>"><%= Html.Supplant(() => InfractionAppeal.GetActiveAppealsCount() > 0 ? new HtmlString("<span class=\"option-count\">" + InfractionAppeal.GetActiveAppealsCount() + "</span>") : new HtmlString("")) %>Appeals</a></li>
                                    <% } %>
                                    <% if (SiteContext.Current.Site.CanDisplayUserCounts()) { %>
                                        <li class="user-interactions-extra-menu-item user-interactions-extra-users">
                                            <%= Html.Supplant(() => {
                                                                        Curse.Cobalt.Web.UserTracking.UserStatistics stats = SiteContext.Current.Site.GetUserStatistics();
                                                                        return new HtmlString("<a class=\"user-interactions-extra-menu-link\" href=\"" + RouteContext.Current.UrlHelper.MemberListIndex() + "?filter-is-online=y\"><i class=\"fa fa-users\"></i>" + stats.OnlineRegisteredUserCount.ToFriendlyString(0, "0") + " / " + stats.OnlineAnonymousUserCount.ToFriendlyString(0, "0") + "</a>");
                                                }) %>
                                        </li>
                                    <% } %>
                                </ul>
                            </div>
                        </div>
                    <% } %>

                <% } else { %>
                    <div class="user-interactions-signin">
                        <a href="<%= Url.AuthenticationLogIn(null) %>" id="login-link" class="user-interactions-action-signin user-interactions-action"><%= CL.Global.Netbar.Sign_In %></a>
                    </div>
                <% } %>
            </div>
        </div>
    </div>
</div>