﻿using Curse.Cobalt.Application;
using Curse.Cobalt.Extensions;
using Curse.Cobalt.Models;
using System.Configuration;

namespace Curse.Cobalt.AmazonAuth
{
    public class AmazonApiConfigHelper : IAmazonApiConfigHelper
    {

        private static Site Site
        {
            get { return SiteContext.Current.Site ?? Site.DefaultSite; }
        }
        private static bool IsDevelopmentConfiguration
        {
            get
            {
                return CobaltConfiguration.ActiveConfiguration == CobaltConfiguration.ConfigurationMode.Development;
            }
        }

        public AmazonApiConfigHelper()
        {
        }
       
        public string AmazonClientID {
            get
            {
                if (IsDevelopmentConfiguration)
                {
                    return ConfigurationManager.AppSettings["AmazonClientID"];
                }

                return Site.AmazonClientID.IsNullOrEmpty() ? ConfigurationManager.AppSettings["AmazonClientID"] : Site.AmazonClientID;
            }
        }
        
        public string AmazonClientSecret {
            get
            {
                if (IsDevelopmentConfiguration)
                {
                    return ConfigurationManager.AppSettings["AmazonClientSecret"];
                }

                return Site.AmazonClientSecret.IsNullOrEmpty() ? ConfigurationManager.AppSettings["AmazonClientSecret"] : Site.AmazonClientSecret;
            }
        }
        public string AmazonRedirectUrl {
            get
            {
                if (IsDevelopmentConfiguration)
                {
                    return SiteContext.Current.BuildSecureAbsoluteUrlFromRelativePath(ConfigurationManager.AppSettings["AmazonRedirectUrl"]);
                }

                return Site.AmazonRedirectUrl.IsNullOrEmpty() 
                    ? SiteContext.Current.BuildSecureAbsoluteUrlFromRelativePath(ConfigurationManager.AppSettings["AmazonRedirectUrl"]) 
                    : SiteContext.Current.BuildSecureAbsoluteUrlFromRelativePath(Site.AmazonRedirectUrl);
            }
        }
        public string AmazonApiUrl {
            get
            {
                if (IsDevelopmentConfiguration)
                {
                    return ConfigurationManager.AppSettings["AmazonApiUrl"];
                }

                return Site.AmazonApiUrl.IsNullOrEmpty() ? ConfigurationManager.AppSettings["AmazonApiUrl"] : Site.AmazonApiUrl;
            }
        }
        public string AmazonAuthUrl {
            get
            {
                if (IsDevelopmentConfiguration)
                {
                    return ConfigurationManager.AppSettings["AmazonAuthUrl"];
                }

                return Site.AmazonAuthUrl.IsNullOrEmpty() ? ConfigurationManager.AppSettings["AmazonAuthUrl"] : Site.AmazonAuthUrl;
            }
        }
    }

    public interface IAmazonApiConfigHelper
    {
        string AmazonClientID { get; }
        string AmazonClientSecret { get; }
        string AmazonRedirectUrl { get; }
        string AmazonApiUrl { get; }
        string AmazonAuthUrl { get; }


    }
}
