﻿using Curse.Cobalt.Authentication;
using Curse.Cobalt.Cookies;

namespace Curse.Cobalt.AmazonAuth
{
    public class AmazonApiUrlHelper : IAmazonApiUrlHelper
    {
        private readonly IAmazonApiConfigHelper _apiConfigHelper;
        public AmazonApiUrlHelper(IAmazonApiConfigHelper apiConfigHelper)
        {
            _apiConfigHelper = apiConfigHelper;
        }

        public string User => $"{_apiConfigHelper.AmazonApiUrl}/user/profile";

        public string GetLogin(string returnUrl)
        {
            return $"{_apiConfigHelper.AmazonAuthUrl}/oa?" +
                   $"client_id={_apiConfigHelper.AmazonClientID}&" +
                   $"scope=profile&" +
                   $"response_type=code&" +
                   $"state={GetState(returnUrl)}&" +
                   $"redirect_uri={_apiConfigHelper.AmazonRedirectUrl}";
        }

        public string TokenInfo => $"{_apiConfigHelper.AmazonApiUrl}/auth/o2/tokeninfo?access_token=";

        public string TokenExchange => $"{_apiConfigHelper.AmazonApiUrl}/auth/o2/token";

        private static string GetState(string returnUrl)
        {
            return OAuthState.GetStateString(returnUrl, new CookieRepository());
        }
    }

    public interface IAmazonApiUrlHelper
    {
        string User { get; }
       
        string TokenExchange { get; }
        string TokenInfo { get; }
        string GetLogin(string returnUrl);

    }
}
