﻿using Curse.Cobalt.Models;
using Curse.Cobalt.Users;

namespace Curse.Cobalt.AmazonAuth
{
    /// <summary>
    /// Decorator class for creating a new Cobalt user from an Amazon user
    /// </summary>
    public class AmazonUserCreator
    {
        private readonly IUserCreator _userCreator;
        public AmazonUserCreator(IUserCreator userCreator)
        {
            _userCreator = userCreator;
        }

        public User Create(AmazonUser amazonUser)
        {
            return _userCreator.CreateUser(amazonUser.DisplayName, amazonUser.Email, amazonUser.ID, ExternalAuthProvider.AmazonProviderID);
        }
    }
}
