﻿using System.Linq;
using System.Web;
using Curse.Cobalt.Application;
using Curse.Cobalt.Models;

namespace Curse.AGS.Application
{
    public class AGSSiteContext : SiteContext
    {
        public AGSSiteContext() { }
        public AGSSiteContext(HttpContextBase httpContext)
            : base(httpContext)
        {
        }

        public static new AGSSiteContext Current
        {
            get
            {
                return (AGSSiteContext)SiteContext.Current;
            }
        }

        public Category NewsCategory
        {
            get
            {
                return Site.Category.CategoryDescendants.Where(c => c.Slug == "news").FirstOrDefault();
            }
        }

        public Category VideosCategory
        {
            get
            {
                return Site.Category.CategoryDescendants.Where(c => c.Slug == "videos").FirstOrDefault();
            }
        }
    }
}